/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.ASN1EncodableVector;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.ASN1Set;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.DEROctetString;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.DERSet;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.AuthEnvelopedData;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.ContentInfo;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSAuthEnvelopedData;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSAuthEnvelopedGenerator;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSTypedData;
import net.snowflake.ingest.internal.org.bouncycastle.cms.CMSUtils;
import net.snowflake.ingest.internal.org.bouncycastle.operator.OutputAEADEncryptor;

public class CMSAuthEnvelopedDataGenerator
extends CMSAuthEnvelopedGenerator {
    private CMSAuthEnvelopedData doGenerate(CMSTypedData cMSTypedData, OutputAEADEncryptor outputAEADEncryptor) throws CMSException {
        ASN1Set aSN1Set;
        Object object;
        ASN1EncodableVector aSN1EncodableVector = CMSUtils.getRecipentInfos(outputAEADEncryptor.getKey(), this.recipientInfoGenerators);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = outputAEADEncryptor.getOutputStream(byteArrayOutputStream);
            cMSTypedData.write((OutputStream)object);
            aSN1Set = CMSUtils.processAuthAttrSet(this.authAttrsGenerator, outputAEADEncryptor);
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new CMSException("unable to process authenticated content: " + iOException.getMessage(), iOException);
        }
        object = byteArrayOutputStream.toByteArray();
        byte[] byArray = outputAEADEncryptor.getMAC();
        EncryptedContentInfo encryptedContentInfo = CMSUtils.getEncryptedContentInfo(cMSTypedData, outputAEADEncryptor, (byte[])object);
        ASN1Set aSN1Set2 = CMSUtils.getAttrDLSet(this.unauthAttrsGenerator);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.authEnvelopedData, new AuthEnvelopedData(this.originatorInfo, new DERSet(aSN1EncodableVector), encryptedContentInfo, aSN1Set, new DEROctetString(byArray), aSN1Set2));
        return new CMSAuthEnvelopedData(contentInfo);
    }

    public CMSAuthEnvelopedData generate(CMSTypedData cMSTypedData, OutputAEADEncryptor outputAEADEncryptor) throws CMSException {
        return this.doGenerate(cMSTypedData, outputAEADEncryptor);
    }
}

