/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.crypto.paddings;

import java.security.SecureRandom;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.InvalidCipherTextException;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.paddings.BlockCipherPadding;

public class TBCPadding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "TBC";
    }

    @Override
    public int addPadding(byte[] byArray, int n) {
        int n2 = byArray.length - n;
        byte by = n > 0 ? (byte)((byArray[n - 1] & 1) == 0 ? 255 : 0) : (byte)((byArray[byArray.length - 1] & 1) == 0 ? 255 : 0);
        while (n < byArray.length) {
            byArray[n] = by;
            ++n;
        }
        return n2;
    }

    @Override
    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n = byArray.length;
        int n2 = byArray[--n] & 0xFF;
        int n3 = 1;
        int n4 = -1;
        while (--n >= 0) {
            int n5 = byArray[n] & 0xFF;
            int n6 = (n5 ^ n2) - 1 >> 31;
            n3 -= (n4 &= n6);
        }
        return n3;
    }
}

