/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.asymmetric.edec;

import java.io.IOException;
import java.security.interfaces.EdECPrivateKey;
import java.security.spec.NamedParameterSpec;
import java.util.Optional;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.interfaces.EdDSAPublicKey;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.asymmetric.edec.BC15EdDSAPublicKey;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;

class BC15EdDSAPrivateKey
extends BCEdDSAPrivateKey
implements EdECPrivateKey {
    BC15EdDSAPrivateKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        super(asymmetricKeyParameter);
    }

    BC15EdDSAPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        super(privateKeyInfo);
    }

    @Override
    public Optional<byte[]> getBytes() {
        if (this.eddsaPrivateKey instanceof Ed448PrivateKeyParameters) {
            return Optional.of(((Ed448PrivateKeyParameters)this.eddsaPrivateKey).getEncoded());
        }
        return Optional.of(((Ed25519PrivateKeyParameters)this.eddsaPrivateKey).getEncoded());
    }

    @Override
    public NamedParameterSpec getParams() {
        if (this.eddsaPrivateKey instanceof Ed448PrivateKeyParameters) {
            return NamedParameterSpec.ED448;
        }
        return NamedParameterSpec.ED25519;
    }

    @Override
    public EdDSAPublicKey getPublicKey() {
        if (this.eddsaPrivateKey instanceof Ed448PrivateKeyParameters) {
            return new BC15EdDSAPublicKey((AsymmetricKeyParameter)((Ed448PrivateKeyParameters)this.eddsaPrivateKey).generatePublicKey());
        }
        return new BC15EdDSAPublicKey((AsymmetricKeyParameter)((Ed25519PrivateKeyParameters)this.eddsaPrivateKey).generatePublicKey());
    }
}

