/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.symmetric;

import net.snowflake.ingest.internal.org.bouncycastle.crypto.BlockCipher;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.BufferedBlockCipher;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.CipherKeyGenerator;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.engines.SerpentEngine;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.engines.TnepresEngine;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.macs.GMac;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.modes.CBCBlockCipher;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.modes.CFBBlockCipher;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.modes.GCMBlockCipher;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.modes.OFBBlockCipher;
import net.snowflake.ingest.internal.org.bouncycastle.internal.asn1.gnu.GNUObjectIdentifiers;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import net.snowflake.ingest.internal.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;

public final class Serpent {
    private Serpent() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Serpent IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new SerpentEngine()), 128);
        }
    }

    public static class CFB
    extends BaseBlockCipher {
        public CFB() {
            super(new BufferedBlockCipher(new CFBBlockCipher(new SerpentEngine(), 128)), 128);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new SerpentEngine();
                }
            });
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Serpent", 192, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = Serpent.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.Serpent", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.Serpent", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.Serpent", PREFIX + "$AlgParams");
            configurableProvider.addAlgorithm("Cipher.Tnepres", PREFIX + "$TECB");
            configurableProvider.addAlgorithm("KeyGenerator.Tnepres", PREFIX + "$TKeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.Tnepres", PREFIX + "$TAlgParams");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_128_ECB, PREFIX + "$ECB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_192_ECB, PREFIX + "$ECB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_256_ECB, PREFIX + "$ECB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_128_CBC, PREFIX + "$CBC");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_192_CBC, PREFIX + "$CBC");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_256_CBC, PREFIX + "$CBC");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_128_CFB, PREFIX + "$CFB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_192_CFB, PREFIX + "$CFB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_256_CFB, PREFIX + "$CFB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_128_OFB, PREFIX + "$OFB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_192_OFB, PREFIX + "$OFB");
            configurableProvider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_256_OFB, PREFIX + "$OFB");
            this.addGMacAlgorithm(configurableProvider, "SERPENT", PREFIX + "$SerpentGMAC", PREFIX + "$KeyGen");
            this.addGMacAlgorithm(configurableProvider, "TNEPRES", PREFIX + "$TSerpentGMAC", PREFIX + "$TKeyGen");
            this.addPoly1305Algorithm(configurableProvider, "SERPENT", PREFIX + "$Poly1305", PREFIX + "$Poly1305KeyGen");
        }
    }

    public static class OFB
    extends BaseBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new OFBBlockCipher(new SerpentEngine(), 128)), 128);
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new net.snowflake.ingest.internal.org.bouncycastle.crypto.macs.Poly1305(new SerpentEngine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-Serpent", 256, new Poly1305KeyGenerator());
        }
    }

    public static class SerpentGMAC
    extends BaseMac {
        public SerpentGMAC() {
            super(new GMac(new GCMBlockCipher(new SerpentEngine())));
        }
    }

    public static class TAlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Tnepres IV";
        }
    }

    public static class TECB
    extends BaseBlockCipher {
        public TECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new TnepresEngine();
                }
            });
        }
    }

    public static class TKeyGen
    extends BaseKeyGenerator {
        public TKeyGen() {
            super("Tnepres", 192, new CipherKeyGenerator());
        }
    }

    public static class TSerpentGMAC
    extends BaseMac {
        public TSerpentGMAC() {
            super(new GMac(new GCMBlockCipher(new TnepresEngine())));
        }
    }
}

