/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.math.ec.rfc8032;

import net.snowflake.ingest.internal.org.bouncycastle.math.ec.rfc8032.Codec;
import net.snowflake.ingest.internal.org.bouncycastle.math.ec.rfc8032.ScalarUtil;
import net.snowflake.ingest.internal.org.bouncycastle.math.ec.rfc8032.Wnaf;
import net.snowflake.ingest.internal.org.bouncycastle.math.raw.Nat;
import net.snowflake.ingest.internal.org.bouncycastle.math.raw.Nat448;

abstract class Scalar448 {
    static final int SIZE = 14;
    private static final int SCALAR_BYTES = 57;
    private static final long M26L = 0x3FFFFFFL;
    private static final long M28L = 0xFFFFFFFL;
    private static final long M32L = 0xFFFFFFFFL;
    private static final int TARGET_LENGTH = 447;
    private static final int[] L = new int[]{-1420278541, 595116690, -1916432555, 560775794, -1361693040, -1001465015, 2093622249, -1, -1, -1, -1, -1, -1, 0x3FFFFFFF};
    private static final int[] LSq = new int[]{463601321, -1045562440, 1239460018, -1189350089, -412821483, 1160071467, -1564970643, 1256291574, -1170454588, -240530412, 2118977290, -1845154869, -1618855054, -1019204973, 1437344377, -1849925303, 1189267370, 280387897, -680846520, -500732508, -1100672524, -1, -1, -1, -1, -1, -1, 0xFFFFFFF};
    private static final int L_0 = 78101261;
    private static final int L_1 = 141809365;
    private static final int L_2 = 175155932;
    private static final int L_3 = 64542499;
    private static final int L_4 = 158326419;
    private static final int L_5 = 191173276;
    private static final int L_6 = 104575268;
    private static final int L_7 = 137584065;
    private static final int L4_0 = 43969588;
    private static final int L4_1 = 30366549;
    private static final int L4_2 = 163752818;
    private static final int L4_3 = 258169998;
    private static final int L4_4 = 96434764;
    private static final int L4_5 = 227822194;
    private static final int L4_6 = 149865618;
    private static final int L4_7 = 550336261;

    Scalar448() {
    }

    static boolean checkVar(byte[] byArray, int[] nArray) {
        if (byArray[56] != 0) {
            return false;
        }
        Scalar448.decode(byArray, nArray);
        return !Nat.gte(14, nArray, L);
    }

    static void decode(byte[] byArray, int[] nArray) {
        Codec.decode32(byArray, 0, nArray, 0, 14);
    }

    static void getOrderWnafVar(int n, byte[] byArray) {
        Wnaf.getSignedVar(L, n, byArray);
    }

    static void multiply225Var(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = new int[22];
        Nat.mul(nArray2, 0, 8, nArray, 0, 14, nArray4, 0);
        if (nArray2[7] < 0) {
            Nat.addTo(14, L, 0, nArray4, 8);
            Nat.subFrom(14, nArray, 0, nArray4, 8);
        }
        byte[] byArray = new byte[88];
        Codec.encode32(nArray4, 0, 22, byArray, 0);
        byte[] byArray2 = Scalar448.reduce704(byArray);
        Scalar448.decode(byArray2, nArray3);
    }

    static byte[] reduce704(byte[] byArray) {
        long l = (long)Codec.decode32(byArray, 0) & 0xFFFFFFFFL;
        long l2 = (long)(Codec.decode24(byArray, 4) << 4) & 0xFFFFFFFFL;
        long l3 = (long)Codec.decode32(byArray, 7) & 0xFFFFFFFFL;
        long l4 = (long)(Codec.decode24(byArray, 11) << 4) & 0xFFFFFFFFL;
        long l5 = (long)Codec.decode32(byArray, 14) & 0xFFFFFFFFL;
        long l6 = (long)(Codec.decode24(byArray, 18) << 4) & 0xFFFFFFFFL;
        long l7 = (long)Codec.decode32(byArray, 21) & 0xFFFFFFFFL;
        long l8 = (long)(Codec.decode24(byArray, 25) << 4) & 0xFFFFFFFFL;
        long l9 = (long)Codec.decode32(byArray, 28) & 0xFFFFFFFFL;
        long l10 = (long)(Codec.decode24(byArray, 32) << 4) & 0xFFFFFFFFL;
        long l11 = (long)Codec.decode32(byArray, 35) & 0xFFFFFFFFL;
        long l12 = (long)(Codec.decode24(byArray, 39) << 4) & 0xFFFFFFFFL;
        long l13 = (long)Codec.decode32(byArray, 42) & 0xFFFFFFFFL;
        long l14 = (long)(Codec.decode24(byArray, 46) << 4) & 0xFFFFFFFFL;
        long l15 = (long)Codec.decode32(byArray, 49) & 0xFFFFFFFFL;
        long l16 = (long)(Codec.decode24(byArray, 53) << 4) & 0xFFFFFFFFL;
        long l17 = (long)Codec.decode32(byArray, 56) & 0xFFFFFFFFL;
        long l18 = (long)(Codec.decode24(byArray, 60) << 4) & 0xFFFFFFFFL;
        long l19 = (long)Codec.decode32(byArray, 63) & 0xFFFFFFFFL;
        long l20 = (long)(Codec.decode24(byArray, 67) << 4) & 0xFFFFFFFFL;
        long l21 = (long)Codec.decode32(byArray, 70) & 0xFFFFFFFFL;
        long l22 = (long)(Codec.decode24(byArray, 74) << 4) & 0xFFFFFFFFL;
        long l23 = (long)Codec.decode32(byArray, 77) & 0xFFFFFFFFL;
        long l24 = (long)(Codec.decode24(byArray, 81) << 4) & 0xFFFFFFFFL;
        long l25 = (long)Codec.decode32(byArray, 84) & 0xFFFFFFFFL;
        long l26 = 0L;
        l26 += l25 >>> 28;
        l25 &= 0xFFFFFFFL;
        l10 += l26 * 43969588L;
        l11 += l26 * 30366549L;
        l12 += l26 * 163752818L;
        l13 += l26 * 258169998L;
        l14 += l26 * 96434764L;
        l15 += l26 * 227822194L;
        l16 += l26 * 149865618L;
        l17 += l26 * 550336261L;
        l22 += l21 >>> 28;
        l21 &= 0xFFFFFFFL;
        l23 += l22 >>> 28;
        l22 &= 0xFFFFFFFL;
        l24 += l23 >>> 28;
        l23 &= 0xFFFFFFFL;
        l25 += l24 >>> 28;
        l24 &= 0xFFFFFFFL;
        l9 += l25 * 43969588L;
        l10 += l25 * 30366549L;
        l11 += l25 * 163752818L;
        l12 += l25 * 258169998L;
        l13 += l25 * 96434764L;
        l14 += l25 * 227822194L;
        l15 += l25 * 149865618L;
        l16 += l25 * 550336261L;
        l8 += l24 * 43969588L;
        l9 += l24 * 30366549L;
        l10 += l24 * 163752818L;
        l11 += l24 * 258169998L;
        l12 += l24 * 96434764L;
        l13 += l24 * 227822194L;
        l14 += l24 * 149865618L;
        l15 += l24 * 550336261L;
        l7 += l23 * 43969588L;
        l8 += l23 * 30366549L;
        l9 += l23 * 163752818L;
        l10 += l23 * 258169998L;
        l11 += l23 * 96434764L;
        l12 += l23 * 227822194L;
        l13 += l23 * 149865618L;
        l14 += l23 * 550336261L;
        l19 += l18 >>> 28;
        l18 &= 0xFFFFFFFL;
        l20 += l19 >>> 28;
        l19 &= 0xFFFFFFFL;
        l21 += l20 >>> 28;
        l20 &= 0xFFFFFFFL;
        l22 += l21 >>> 28;
        l21 &= 0xFFFFFFFL;
        l6 += l22 * 43969588L;
        l7 += l22 * 30366549L;
        l8 += l22 * 163752818L;
        l9 += l22 * 258169998L;
        l10 += l22 * 96434764L;
        l11 += l22 * 227822194L;
        l12 += l22 * 149865618L;
        l13 += l22 * 550336261L;
        l5 += l21 * 43969588L;
        l6 += l21 * 30366549L;
        l7 += l21 * 163752818L;
        l8 += l21 * 258169998L;
        l9 += l21 * 96434764L;
        l10 += l21 * 227822194L;
        l11 += l21 * 149865618L;
        l12 += l21 * 550336261L;
        l4 += l20 * 43969588L;
        l5 += l20 * 30366549L;
        l6 += l20 * 163752818L;
        l7 += l20 * 258169998L;
        l8 += l20 * 96434764L;
        l9 += l20 * 227822194L;
        l10 += l20 * 149865618L;
        l11 += l20 * 550336261L;
        l16 += l15 >>> 28;
        l15 &= 0xFFFFFFFL;
        l17 += l16 >>> 28;
        l16 &= 0xFFFFFFFL;
        l18 += l17 >>> 28;
        l17 &= 0xFFFFFFFL;
        l19 += l18 >>> 28;
        l18 &= 0xFFFFFFFL;
        l3 += l19 * 43969588L;
        l4 += l19 * 30366549L;
        l5 += l19 * 163752818L;
        l6 += l19 * 258169998L;
        l7 += l19 * 96434764L;
        l8 += l19 * 227822194L;
        l9 += l19 * 149865618L;
        l10 += l19 * 550336261L;
        l2 += l18 * 43969588L;
        l3 += l18 * 30366549L;
        l4 += l18 * 163752818L;
        l5 += l18 * 258169998L;
        l6 += l18 * 96434764L;
        l7 += l18 * 227822194L;
        l8 += l18 * 149865618L;
        l9 += l18 * 550336261L;
        l17 *= 4L;
        l17 += l16 >>> 26;
        l16 &= 0x3FFFFFFL;
        l += ++l17 * 78101261L;
        l2 += l17 * 141809365L;
        l3 += l17 * 175155932L;
        l4 += l17 * 64542499L;
        l5 += l17 * 158326419L;
        l6 += l17 * 191173276L;
        l7 += l17 * 104575268L;
        l8 += l17 * 137584065L;
        l2 += l >>> 28;
        l &= 0xFFFFFFFL;
        l3 += l2 >>> 28;
        l2 &= 0xFFFFFFFL;
        l4 += l3 >>> 28;
        l3 &= 0xFFFFFFFL;
        l5 += l4 >>> 28;
        l4 &= 0xFFFFFFFL;
        l6 += l5 >>> 28;
        l5 &= 0xFFFFFFFL;
        l7 += l6 >>> 28;
        l6 &= 0xFFFFFFFL;
        l8 += l7 >>> 28;
        l7 &= 0xFFFFFFFL;
        l9 += l8 >>> 28;
        l8 &= 0xFFFFFFFL;
        l10 += l9 >>> 28;
        l9 &= 0xFFFFFFFL;
        l11 += l10 >>> 28;
        l10 &= 0xFFFFFFFL;
        l12 += l11 >>> 28;
        l11 &= 0xFFFFFFFL;
        l13 += l12 >>> 28;
        l12 &= 0xFFFFFFFL;
        l14 += l13 >>> 28;
        l13 &= 0xFFFFFFFL;
        l15 += l14 >>> 28;
        l14 &= 0xFFFFFFFL;
        l16 += l15 >>> 28;
        l15 &= 0xFFFFFFFL;
        l17 = l16 >>> 26;
        l16 &= 0x3FFFFFFL;
        l -= --l17 & 0x4A7BB0DL;
        l2 -= l17 & 0x873D6D5L;
        l3 -= l17 & 0xA70AADCL;
        l4 -= l17 & 0x3D8D723L;
        l5 -= l17 & 0x96FDE93L;
        l6 -= l17 & 0xB65129CL;
        l7 -= l17 & 0x63BB124L;
        l8 -= l17 & 0x8335DC1L;
        l2 += l >> 28;
        l &= 0xFFFFFFFL;
        l3 += l2 >> 28;
        l2 &= 0xFFFFFFFL;
        l4 += l3 >> 28;
        l3 &= 0xFFFFFFFL;
        l5 += l4 >> 28;
        l4 &= 0xFFFFFFFL;
        l6 += l5 >> 28;
        l5 &= 0xFFFFFFFL;
        l7 += l6 >> 28;
        l6 &= 0xFFFFFFFL;
        l8 += l7 >> 28;
        l7 &= 0xFFFFFFFL;
        l9 += l8 >> 28;
        l8 &= 0xFFFFFFFL;
        l10 += l9 >> 28;
        l9 &= 0xFFFFFFFL;
        l11 += l10 >> 28;
        l10 &= 0xFFFFFFFL;
        l12 += l11 >> 28;
        l11 &= 0xFFFFFFFL;
        l13 += l12 >> 28;
        l12 &= 0xFFFFFFFL;
        l14 += l13 >> 28;
        l13 &= 0xFFFFFFFL;
        l15 += l14 >> 28;
        l14 &= 0xFFFFFFFL;
        l16 += l15 >> 28;
        l15 &= 0xFFFFFFFL;
        byte[] byArray2 = new byte[57];
        Codec.encode56(l | l2 << 28, byArray2, 0);
        Codec.encode56(l3 | l4 << 28, byArray2, 7);
        Codec.encode56(l5 | l6 << 28, byArray2, 14);
        Codec.encode56(l7 | l8 << 28, byArray2, 21);
        Codec.encode56(l9 | l10 << 28, byArray2, 28);
        Codec.encode56(l11 | l12 << 28, byArray2, 35);
        Codec.encode56(l13 | l14 << 28, byArray2, 42);
        Codec.encode56(l15 | l16 << 28, byArray2, 49);
        return byArray2;
    }

    static byte[] reduce912(byte[] byArray) {
        long l = (long)Codec.decode32(byArray, 0) & 0xFFFFFFFFL;
        long l2 = (long)(Codec.decode24(byArray, 4) << 4) & 0xFFFFFFFFL;
        long l3 = (long)Codec.decode32(byArray, 7) & 0xFFFFFFFFL;
        long l4 = (long)(Codec.decode24(byArray, 11) << 4) & 0xFFFFFFFFL;
        long l5 = (long)Codec.decode32(byArray, 14) & 0xFFFFFFFFL;
        long l6 = (long)(Codec.decode24(byArray, 18) << 4) & 0xFFFFFFFFL;
        long l7 = (long)Codec.decode32(byArray, 21) & 0xFFFFFFFFL;
        long l8 = (long)(Codec.decode24(byArray, 25) << 4) & 0xFFFFFFFFL;
        long l9 = (long)Codec.decode32(byArray, 28) & 0xFFFFFFFFL;
        long l10 = (long)(Codec.decode24(byArray, 32) << 4) & 0xFFFFFFFFL;
        long l11 = (long)Codec.decode32(byArray, 35) & 0xFFFFFFFFL;
        long l12 = (long)(Codec.decode24(byArray, 39) << 4) & 0xFFFFFFFFL;
        long l13 = (long)Codec.decode32(byArray, 42) & 0xFFFFFFFFL;
        long l14 = (long)(Codec.decode24(byArray, 46) << 4) & 0xFFFFFFFFL;
        long l15 = (long)Codec.decode32(byArray, 49) & 0xFFFFFFFFL;
        long l16 = (long)(Codec.decode24(byArray, 53) << 4) & 0xFFFFFFFFL;
        long l17 = (long)Codec.decode32(byArray, 56) & 0xFFFFFFFFL;
        long l18 = (long)(Codec.decode24(byArray, 60) << 4) & 0xFFFFFFFFL;
        long l19 = (long)Codec.decode32(byArray, 63) & 0xFFFFFFFFL;
        long l20 = (long)(Codec.decode24(byArray, 67) << 4) & 0xFFFFFFFFL;
        long l21 = (long)Codec.decode32(byArray, 70) & 0xFFFFFFFFL;
        long l22 = (long)(Codec.decode24(byArray, 74) << 4) & 0xFFFFFFFFL;
        long l23 = (long)Codec.decode32(byArray, 77) & 0xFFFFFFFFL;
        long l24 = (long)(Codec.decode24(byArray, 81) << 4) & 0xFFFFFFFFL;
        long l25 = (long)Codec.decode32(byArray, 84) & 0xFFFFFFFFL;
        long l26 = (long)(Codec.decode24(byArray, 88) << 4) & 0xFFFFFFFFL;
        long l27 = (long)Codec.decode32(byArray, 91) & 0xFFFFFFFFL;
        long l28 = (long)(Codec.decode24(byArray, 95) << 4) & 0xFFFFFFFFL;
        long l29 = (long)Codec.decode32(byArray, 98) & 0xFFFFFFFFL;
        long l30 = (long)(Codec.decode24(byArray, 102) << 4) & 0xFFFFFFFFL;
        long l31 = (long)Codec.decode32(byArray, 105) & 0xFFFFFFFFL;
        long l32 = (long)(Codec.decode24(byArray, 109) << 4) & 0xFFFFFFFFL;
        long l33 = (long)Codec.decode16(byArray, 112) & 0xFFFFFFFFL;
        l17 += l33 * 43969588L;
        l18 += l33 * 30366549L;
        l19 += l33 * 163752818L;
        l20 += l33 * 258169998L;
        l21 += l33 * 96434764L;
        l22 += l33 * 227822194L;
        l23 += l33 * 149865618L;
        l24 += l33 * 550336261L;
        l32 += l31 >>> 28;
        l31 &= 0xFFFFFFFL;
        l16 += l32 * 43969588L;
        l17 += l32 * 30366549L;
        l18 += l32 * 163752818L;
        l19 += l32 * 258169998L;
        l20 += l32 * 96434764L;
        l21 += l32 * 227822194L;
        l22 += l32 * 149865618L;
        l23 += l32 * 550336261L;
        l15 += l31 * 43969588L;
        l16 += l31 * 30366549L;
        l17 += l31 * 163752818L;
        l18 += l31 * 258169998L;
        l19 += l31 * 96434764L;
        l20 += l31 * 227822194L;
        l21 += l31 * 149865618L;
        l22 += l31 * 550336261L;
        l30 += l29 >>> 28;
        l29 &= 0xFFFFFFFL;
        l14 += l30 * 43969588L;
        l15 += l30 * 30366549L;
        l16 += l30 * 163752818L;
        l17 += l30 * 258169998L;
        l18 += l30 * 96434764L;
        l19 += l30 * 227822194L;
        l20 += l30 * 149865618L;
        l21 += l30 * 550336261L;
        l13 += l29 * 43969588L;
        l14 += l29 * 30366549L;
        l15 += l29 * 163752818L;
        l16 += l29 * 258169998L;
        l17 += l29 * 96434764L;
        l18 += l29 * 227822194L;
        l19 += l29 * 149865618L;
        l20 += l29 * 550336261L;
        l28 += l27 >>> 28;
        l27 &= 0xFFFFFFFL;
        l12 += l28 * 43969588L;
        l13 += l28 * 30366549L;
        l14 += l28 * 163752818L;
        l15 += l28 * 258169998L;
        l16 += l28 * 96434764L;
        l17 += l28 * 227822194L;
        l18 += l28 * 149865618L;
        l19 += l28 * 550336261L;
        l11 += l27 * 43969588L;
        l12 += l27 * 30366549L;
        l13 += l27 * 163752818L;
        l14 += l27 * 258169998L;
        l15 += l27 * 96434764L;
        l16 += l27 * 227822194L;
        l17 += l27 * 149865618L;
        l18 += l27 * 550336261L;
        l26 += l25 >>> 28;
        l25 &= 0xFFFFFFFL;
        l10 += l26 * 43969588L;
        l11 += l26 * 30366549L;
        l12 += l26 * 163752818L;
        l13 += l26 * 258169998L;
        l14 += l26 * 96434764L;
        l15 += l26 * 227822194L;
        l16 += l26 * 149865618L;
        l17 += l26 * 550336261L;
        l22 += l21 >>> 28;
        l21 &= 0xFFFFFFFL;
        l23 += l22 >>> 28;
        l22 &= 0xFFFFFFFL;
        l24 += l23 >>> 28;
        l23 &= 0xFFFFFFFL;
        l25 += l24 >>> 28;
        l24 &= 0xFFFFFFFL;
        l9 += l25 * 43969588L;
        l10 += l25 * 30366549L;
        l11 += l25 * 163752818L;
        l12 += l25 * 258169998L;
        l13 += l25 * 96434764L;
        l14 += l25 * 227822194L;
        l15 += l25 * 149865618L;
        l16 += l25 * 550336261L;
        l8 += l24 * 43969588L;
        l9 += l24 * 30366549L;
        l10 += l24 * 163752818L;
        l11 += l24 * 258169998L;
        l12 += l24 * 96434764L;
        l13 += l24 * 227822194L;
        l14 += l24 * 149865618L;
        l15 += l24 * 550336261L;
        l7 += l23 * 43969588L;
        l8 += l23 * 30366549L;
        l9 += l23 * 163752818L;
        l10 += l23 * 258169998L;
        l11 += l23 * 96434764L;
        l12 += l23 * 227822194L;
        l13 += l23 * 149865618L;
        l14 += l23 * 550336261L;
        l19 += l18 >>> 28;
        l18 &= 0xFFFFFFFL;
        l20 += l19 >>> 28;
        l19 &= 0xFFFFFFFL;
        l21 += l20 >>> 28;
        l20 &= 0xFFFFFFFL;
        l22 += l21 >>> 28;
        l21 &= 0xFFFFFFFL;
        l6 += l22 * 43969588L;
        l7 += l22 * 30366549L;
        l8 += l22 * 163752818L;
        l9 += l22 * 258169998L;
        l10 += l22 * 96434764L;
        l11 += l22 * 227822194L;
        l12 += l22 * 149865618L;
        l13 += l22 * 550336261L;
        l5 += l21 * 43969588L;
        l6 += l21 * 30366549L;
        l7 += l21 * 163752818L;
        l8 += l21 * 258169998L;
        l9 += l21 * 96434764L;
        l10 += l21 * 227822194L;
        l11 += l21 * 149865618L;
        l12 += l21 * 550336261L;
        l4 += l20 * 43969588L;
        l5 += l20 * 30366549L;
        l6 += l20 * 163752818L;
        l7 += l20 * 258169998L;
        l8 += l20 * 96434764L;
        l9 += l20 * 227822194L;
        l10 += l20 * 149865618L;
        l11 += l20 * 550336261L;
        l16 += l15 >>> 28;
        l15 &= 0xFFFFFFFL;
        l17 += l16 >>> 28;
        l16 &= 0xFFFFFFFL;
        l18 += l17 >>> 28;
        l17 &= 0xFFFFFFFL;
        l19 += l18 >>> 28;
        l18 &= 0xFFFFFFFL;
        l3 += l19 * 43969588L;
        l4 += l19 * 30366549L;
        l5 += l19 * 163752818L;
        l6 += l19 * 258169998L;
        l7 += l19 * 96434764L;
        l8 += l19 * 227822194L;
        l9 += l19 * 149865618L;
        l10 += l19 * 550336261L;
        l2 += l18 * 43969588L;
        l3 += l18 * 30366549L;
        l4 += l18 * 163752818L;
        l5 += l18 * 258169998L;
        l6 += l18 * 96434764L;
        l7 += l18 * 227822194L;
        l8 += l18 * 149865618L;
        l9 += l18 * 550336261L;
        l17 *= 4L;
        l17 += l16 >>> 26;
        l16 &= 0x3FFFFFFL;
        l += ++l17 * 78101261L;
        l2 += l17 * 141809365L;
        l3 += l17 * 175155932L;
        l4 += l17 * 64542499L;
        l5 += l17 * 158326419L;
        l6 += l17 * 191173276L;
        l7 += l17 * 104575268L;
        l8 += l17 * 137584065L;
        l2 += l >>> 28;
        l &= 0xFFFFFFFL;
        l3 += l2 >>> 28;
        l2 &= 0xFFFFFFFL;
        l4 += l3 >>> 28;
        l3 &= 0xFFFFFFFL;
        l5 += l4 >>> 28;
        l4 &= 0xFFFFFFFL;
        l6 += l5 >>> 28;
        l5 &= 0xFFFFFFFL;
        l7 += l6 >>> 28;
        l6 &= 0xFFFFFFFL;
        l8 += l7 >>> 28;
        l7 &= 0xFFFFFFFL;
        l9 += l8 >>> 28;
        l8 &= 0xFFFFFFFL;
        l10 += l9 >>> 28;
        l9 &= 0xFFFFFFFL;
        l11 += l10 >>> 28;
        l10 &= 0xFFFFFFFL;
        l12 += l11 >>> 28;
        l11 &= 0xFFFFFFFL;
        l13 += l12 >>> 28;
        l12 &= 0xFFFFFFFL;
        l14 += l13 >>> 28;
        l13 &= 0xFFFFFFFL;
        l15 += l14 >>> 28;
        l14 &= 0xFFFFFFFL;
        l16 += l15 >>> 28;
        l15 &= 0xFFFFFFFL;
        l17 = l16 >>> 26;
        l16 &= 0x3FFFFFFL;
        l -= --l17 & 0x4A7BB0DL;
        l2 -= l17 & 0x873D6D5L;
        l3 -= l17 & 0xA70AADCL;
        l4 -= l17 & 0x3D8D723L;
        l5 -= l17 & 0x96FDE93L;
        l6 -= l17 & 0xB65129CL;
        l7 -= l17 & 0x63BB124L;
        l8 -= l17 & 0x8335DC1L;
        l2 += l >> 28;
        l &= 0xFFFFFFFL;
        l3 += l2 >> 28;
        l2 &= 0xFFFFFFFL;
        l4 += l3 >> 28;
        l3 &= 0xFFFFFFFL;
        l5 += l4 >> 28;
        l4 &= 0xFFFFFFFL;
        l6 += l5 >> 28;
        l5 &= 0xFFFFFFFL;
        l7 += l6 >> 28;
        l6 &= 0xFFFFFFFL;
        l8 += l7 >> 28;
        l7 &= 0xFFFFFFFL;
        l9 += l8 >> 28;
        l8 &= 0xFFFFFFFL;
        l10 += l9 >> 28;
        l9 &= 0xFFFFFFFL;
        l11 += l10 >> 28;
        l10 &= 0xFFFFFFFL;
        l12 += l11 >> 28;
        l11 &= 0xFFFFFFFL;
        l13 += l12 >> 28;
        l12 &= 0xFFFFFFFL;
        l14 += l13 >> 28;
        l13 &= 0xFFFFFFFL;
        l15 += l14 >> 28;
        l14 &= 0xFFFFFFFL;
        l16 += l15 >> 28;
        l15 &= 0xFFFFFFFL;
        byte[] byArray2 = new byte[57];
        Codec.encode56(l | l2 << 28, byArray2, 0);
        Codec.encode56(l3 | l4 << 28, byArray2, 7);
        Codec.encode56(l5 | l6 << 28, byArray2, 14);
        Codec.encode56(l7 | l8 << 28, byArray2, 21);
        Codec.encode56(l9 | l10 << 28, byArray2, 28);
        Codec.encode56(l11 | l12 << 28, byArray2, 35);
        Codec.encode56(l13 | l14 << 28, byArray2, 42);
        Codec.encode56(l15 | l16 << 28, byArray2, 49);
        return byArray2;
    }

    static boolean reduceBasisVar(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = new int[28];
        System.arraycopy(LSq, 0, nArray4, 0, 28);
        int[] nArray5 = new int[28];
        Nat448.square(nArray, nArray5);
        nArray5[0] = nArray5[0] + 1;
        int[] nArray6 = new int[28];
        Nat448.mul(L, nArray, nArray6);
        int[] nArray7 = new int[28];
        int[] nArray8 = new int[8];
        System.arraycopy(L, 0, nArray8, 0, 8);
        int[] nArray9 = new int[8];
        int[] nArray10 = new int[8];
        System.arraycopy(nArray, 0, nArray10, 0, 8);
        int[] nArray11 = new int[8];
        nArray11[0] = 1;
        int n = 1788;
        int n2 = 27;
        int n3 = ScalarUtil.getBitLengthPositive(n2, nArray5);
        while (n3 > 447) {
            if (--n < 0) {
                return false;
            }
            int n4 = ScalarUtil.getBitLength(n2, nArray6);
            int n5 = n4 - n3;
            n5 &= ~(n5 >> 31);
            if (nArray6[n2] < 0) {
                ScalarUtil.addShifted_NP(n2, n5, nArray4, nArray5, nArray6, nArray7);
                ScalarUtil.addShifted_UV(7, n5, nArray8, nArray9, nArray10, nArray11);
            } else {
                ScalarUtil.subShifted_NP(n2, n5, nArray4, nArray5, nArray6, nArray7);
                ScalarUtil.subShifted_UV(7, n5, nArray8, nArray9, nArray10, nArray11);
            }
            if (!ScalarUtil.lessThan(n2, nArray4, nArray5)) continue;
            int[] nArray12 = nArray8;
            nArray8 = nArray10;
            nArray10 = nArray12;
            int[] nArray13 = nArray9;
            nArray9 = nArray11;
            nArray11 = nArray13;
            int[] nArray14 = nArray4;
            nArray4 = nArray5;
            nArray5 = nArray14;
            n2 = n3 >>> 5;
            n3 = ScalarUtil.getBitLengthPositive(n2, nArray5);
        }
        System.arraycopy(nArray10, 0, nArray2, 0, 8);
        System.arraycopy(nArray11, 0, nArray3, 0, 8);
        return true;
    }

    static void toSignedDigits(int n, int[] nArray, int[] nArray2) {
        nArray2[14] = (1 << n - 448) + Nat.cadd(14, ~nArray[0] & 1, nArray, L, nArray2);
        Nat.shiftDownBit(15, nArray2, 0);
    }
}

