/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.xwing;

import java.security.SecureRandom;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.KeyGenerationParameters;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import net.snowflake.ingest.internal.org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyGenerationParameters;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyPairGenerator;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.xwing.XWingPrivateKeyParameters;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.xwing.XWingPublicKeyParameters;

public class XWingKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    private void initialize(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        KyberKeyPairGenerator kyberKeyPairGenerator = new KyberKeyPairGenerator();
        kyberKeyPairGenerator.init(new KyberKeyGenerationParameters(this.random, KyberParameters.kyber768));
        X25519KeyPairGenerator x25519KeyPairGenerator = new X25519KeyPairGenerator();
        x25519KeyPairGenerator.init(new X25519KeyGenerationParameters(this.random));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = kyberKeyPairGenerator.generateKeyPair();
        AsymmetricCipherKeyPair asymmetricCipherKeyPair2 = x25519KeyPairGenerator.generateKeyPair();
        return new AsymmetricCipherKeyPair(new XWingPublicKeyParameters(asymmetricCipherKeyPair.getPublic(), asymmetricCipherKeyPair2.getPublic()), new XWingPrivateKeyParameters(asymmetricCipherKeyPair.getPrivate(), asymmetricCipherKeyPair2.getPrivate()));
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

