/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.org.bouncycastle.pqc.jcajce.provider.hqc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import net.snowflake.ingest.internal.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.jcajce.interfaces.HQCKey;
import net.snowflake.ingest.internal.org.bouncycastle.pqc.jcajce.spec.HQCParameterSpec;
import net.snowflake.ingest.internal.org.bouncycastle.util.Arrays;
import net.snowflake.ingest.internal.org.bouncycastle.util.Strings;

public class BCHQCPublicKey
implements PublicKey,
HQCKey {
    private static final long serialVersionUID = 1L;
    private transient HQCPublicKeyParameters params;

    public BCHQCPublicKey(HQCPublicKeyParameters hQCPublicKeyParameters) {
        this.params = hQCPublicKeyParameters;
    }

    public BCHQCPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (HQCPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCHQCPublicKey) {
            BCHQCPublicKey bCHQCPublicKey = (BCHQCPublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCHQCPublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public HQCParameterSpec getParameterSpec() {
        return HQCParameterSpec.fromName(this.params.getParameters().getName());
    }

    HQCPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

