/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.shaded.parquet.com.fasterxml.jackson.datatype.jdk8;

import java.io.IOException;
import java.util.stream.DoubleStream;
import net.snowflake.ingest.internal.shaded.parquet.com.fasterxml.jackson.core.JsonGenerator;
import net.snowflake.ingest.internal.shaded.parquet.com.fasterxml.jackson.databind.SerializerProvider;
import net.snowflake.ingest.internal.shaded.parquet.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import net.snowflake.ingest.internal.shaded.parquet.com.fasterxml.jackson.datatype.jdk8.WrappedIOException;

public class DoubleStreamSerializer
extends StdSerializer<DoubleStream> {
    private static final long serialVersionUID = 1L;
    public static final DoubleStreamSerializer INSTANCE = new DoubleStreamSerializer();

    private DoubleStreamSerializer() {
        super(DoubleStream.class);
    }

    @Override
    public void serialize(DoubleStream stream, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        try (DoubleStream ds = stream;){
            jgen.writeStartArray();
            ds.forEachOrdered(value -> {
                try {
                    jgen.writeNumber(value);
                }
                catch (IOException e) {
                    throw new WrappedIOException(e);
                }
            });
            jgen.writeEndArray();
        }
        catch (WrappedIOException e) {
            throw e.getCause();
        }
    }
}

