/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.nio.ByteBuffer;
import net.snowflake.ingest.internal.apache.commons.codec.binary.Hex;

public class BinaryStringUtils {
    private static final int MAX_LOB_LEN = 32;

    static int unicodeCharactersCount(String s2) {
        return s2.codePointCount(0, s2.length());
    }

    static String truncateBytesAsHex(byte[] bytes, boolean truncateUp) {
        if (bytes.length <= 32) {
            return Hex.encodeHexString(bytes);
        }
        byte[] result = new byte[32];
        System.arraycopy(bytes, 0, result, 0, 32);
        if (truncateUp) {
            int idx = 31;
            while (idx >= 0) {
                int n = idx--;
                result[n] = (byte)(result[n] + 1);
                if (result[n] != 0) break;
            }
            if (idx == -1) {
                return "Z";
            }
        }
        return Hex.encodeHexString(ByteBuffer.wrap(result, 0, 32));
    }
}

