/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.util.List;
import net.snowflake.ingest.internal.com.google.common.annotations.VisibleForTesting;
import net.snowflake.ingest.internal.fasterxml.jackson.annotation.JsonIgnore;
import net.snowflake.ingest.internal.fasterxml.jackson.annotation.JsonProperty;
import net.snowflake.ingest.streaming.internal.BlobStats;
import net.snowflake.ingest.streaming.internal.ChunkMetadata;
import net.snowflake.ingest.utils.Constants;
import net.snowflake.ingest.utils.ParameterProvider;

class BlobMetadata {
    private final String path;
    private final String md5;
    private final Constants.BdecVersion bdecVersion;
    private final List<ChunkMetadata> chunks;
    private final BlobStats blobStats;
    private final boolean spansMixedTables;

    @VisibleForTesting
    BlobMetadata(String path, String md5, List<ChunkMetadata> chunks, BlobStats blobStats) {
        this(path, md5, ParameterProvider.BLOB_FORMAT_VERSION_DEFAULT, chunks, blobStats, chunks == null ? false : chunks.size() > 1);
    }

    BlobMetadata(String path, String md5, Constants.BdecVersion bdecVersion, List<ChunkMetadata> chunks, BlobStats blobStats, boolean spansMixedTables) {
        this.path = path;
        this.md5 = md5;
        this.bdecVersion = bdecVersion;
        this.chunks = chunks;
        this.blobStats = blobStats;
        this.spansMixedTables = spansMixedTables;
    }

    @JsonIgnore
    Constants.BdecVersion getVersion() {
        return this.bdecVersion;
    }

    @JsonProperty(value="path")
    String getPath() {
        return this.path;
    }

    @JsonProperty(value="md5")
    String getMD5() {
        return this.md5;
    }

    @JsonProperty(value="chunks")
    List<ChunkMetadata> getChunks() {
        return this.chunks;
    }

    @JsonProperty(value="bdec_version")
    byte getVersionByte() {
        return this.bdecVersion.toByte();
    }

    @JsonProperty(value="blob_stats")
    BlobStats getBlobStats() {
        return this.blobStats;
    }

    @JsonProperty(value="spans_mixed_tables")
    boolean getSpansMixedTables() {
        return this.spansMixedTables;
    }

    static BlobMetadata createBlobMetadata(String path, String md5, Constants.BdecVersion bdecVersion, List<ChunkMetadata> chunks, BlobStats blobStats, boolean spansMixedTables) {
        return new BlobMetadata(path, md5, bdecVersion, chunks, blobStats, spansMixedTables);
    }
}

