/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.util.List;
import java.util.stream.Collectors;
import net.snowflake.ingest.internal.fasterxml.jackson.annotation.JsonProperty;
import net.snowflake.ingest.streaming.internal.IStreamingIngestRequest;
import net.snowflake.ingest.streaming.internal.SnowflakeStreamingIngestChannelInternal;
import net.snowflake.ingest.utils.Utils;

class ChannelsStatusRequest
implements IStreamingIngestRequest {
    private List<ChannelStatusRequestDTO> channels;
    private String role;

    ChannelsStatusRequest() {
    }

    @JsonProperty(value="role")
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    public void setRole(String role) {
        this.role = role;
    }

    @JsonProperty(value="channels")
    void setChannels(List<ChannelStatusRequestDTO> channels) {
        this.channels = channels;
    }

    @JsonProperty(value="channels")
    List<ChannelStatusRequestDTO> getChannels() {
        return this.channels;
    }

    @Override
    public String getStringForLogging() {
        return String.format("ChannelsStatusRequest(role=%s, channels=[%s])", this.role, this.channels.stream().map(r -> Utils.getFullyQualifiedChannelName(r.getDatabaseName(), r.getSchemaName(), r.getTableName(), r.getChannelName())).collect(Collectors.joining(", ")));
    }

    static class ChannelStatusRequestDTO {
        private final String databaseName;
        private final String schemaName;
        private final String tableName;
        private final String channelName;
        private final Long clientSequencer;

        ChannelStatusRequestDTO(SnowflakeStreamingIngestChannelInternal channel) {
            this.channelName = channel.getName();
            this.databaseName = channel.getDBName();
            this.schemaName = channel.getSchemaName();
            this.tableName = channel.getTableName();
            this.clientSequencer = channel.getChannelSequencer();
        }

        @JsonProperty(value="table")
        String getTableName() {
            return this.tableName;
        }

        @JsonProperty(value="database")
        String getDatabaseName() {
            return this.databaseName;
        }

        @JsonProperty(value="schema")
        String getSchemaName() {
            return this.schemaName;
        }

        @JsonProperty(value="channel_name")
        String getChannelName() {
            return this.channelName;
        }

        @JsonProperty(value="client_sequencer")
        Long getClientSequencer() {
            return this.clientSequencer;
        }
    }
}

