/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import net.snowflake.ingest.streaming.internal.SnowflakeStreamingIngestClientInternal;
import net.snowflake.ingest.utils.Constants;
import net.snowflake.ingest.utils.ParameterProvider;

public class ClientBufferParameters {
    private boolean enableParquetInternalBuffering;
    private long maxChunkSizeInBytes;
    private long maxAllowedRowSizeInBytes;
    private Constants.BdecParquetCompression bdecParquetCompression;

    private ClientBufferParameters(boolean enableParquetInternalBuffering, long maxChunkSizeInBytes, long maxAllowedRowSizeInBytes, Constants.BdecParquetCompression bdecParquetCompression) {
        this.enableParquetInternalBuffering = enableParquetInternalBuffering;
        this.maxChunkSizeInBytes = maxChunkSizeInBytes;
        this.maxAllowedRowSizeInBytes = maxAllowedRowSizeInBytes;
        this.bdecParquetCompression = bdecParquetCompression;
    }

    public ClientBufferParameters(SnowflakeStreamingIngestClientInternal clientInternal) {
        this.enableParquetInternalBuffering = clientInternal != null ? clientInternal.getParameterProvider().getEnableParquetInternalBuffering() : false;
        this.maxChunkSizeInBytes = clientInternal != null ? clientInternal.getParameterProvider().getMaxChunkSizeInBytes() : 0x10000000L;
        this.maxAllowedRowSizeInBytes = clientInternal != null ? clientInternal.getParameterProvider().getMaxAllowedRowSizeInBytes() : 0x4000000L;
        this.bdecParquetCompression = clientInternal != null ? clientInternal.getParameterProvider().getBdecParquetCompressionAlgorithm() : ParameterProvider.BDEC_PARQUET_COMPRESSION_ALGORITHM_DEFAULT;
    }

    public static ClientBufferParameters test_createClientBufferParameters(boolean enableParquetInternalBuffering, long maxChunkSizeInBytes, long maxAllowedRowSizeInBytes, Constants.BdecParquetCompression bdecParquetCompression) {
        return new ClientBufferParameters(enableParquetInternalBuffering, maxChunkSizeInBytes, maxAllowedRowSizeInBytes, bdecParquetCompression);
    }

    public boolean getEnableParquetInternalBuffering() {
        return this.enableParquetInternalBuffering;
    }

    public long getMaxChunkSizeInBytes() {
        return this.maxChunkSizeInBytes;
    }

    public long getMaxAllowedRowSizeInBytes() {
        return this.maxAllowedRowSizeInBytes;
    }

    public Constants.BdecParquetCompression getBdecParquetCompression() {
        return this.bdecParquetCompression;
    }
}

