/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import net.snowflake.ingest.internal.fasterxml.jackson.annotation.JsonInclude;
import net.snowflake.ingest.internal.fasterxml.jackson.annotation.JsonProperty;
import net.snowflake.ingest.streaming.internal.IStreamingIngestRequest;
import net.snowflake.ingest.utils.Utils;

class DropChannelRequestInternal
implements IStreamingIngestRequest {
    @JsonProperty(value="request_id")
    private String requestId;
    @JsonProperty(value="role")
    private String role;
    @JsonProperty(value="channel")
    private String channel;
    @JsonProperty(value="table")
    private String table;
    @JsonProperty(value="database")
    private String database;
    @JsonProperty(value="schema")
    private String schema;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="client_sequencer")
    Long clientSequencer;

    DropChannelRequestInternal(String requestId, String role, String database, String schema, String table, String channel, Long clientSequencer) {
        this.requestId = requestId;
        this.role = role;
        this.database = database;
        this.schema = schema;
        this.table = table;
        this.channel = channel;
        this.clientSequencer = clientSequencer;
    }

    String getRequestId() {
        return this.requestId;
    }

    String getRole() {
        return this.role;
    }

    String getChannel() {
        return this.channel;
    }

    String getTable() {
        return this.table;
    }

    String getDatabase() {
        return this.database;
    }

    String getSchema() {
        return this.schema;
    }

    Long getClientSequencer() {
        return this.clientSequencer;
    }

    String getFullyQualifiedTableName() {
        return Utils.getFullyQualifiedTableName(this.database, this.schema, this.table);
    }

    @Override
    public String getStringForLogging() {
        return String.format("DropChannelRequest(requestId=%s, role=%s, db=%s, schema=%s, table=%s, channel=%s, clientSequencer=%s)", this.requestId, this.role, this.database, this.schema, this.table, this.channel, this.clientSequencer);
    }
}

