/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.util.Map;
import net.snowflake.ingest.internal.fasterxml.jackson.annotation.JsonProperty;
import net.snowflake.ingest.streaming.internal.FileColumnProperties;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;

class EpInfo {
    private long rowCount;
    private Map<String, FileColumnProperties> columnEps;

    EpInfo() {
    }

    EpInfo(long rowCount, Map<String, FileColumnProperties> columnEps) {
        this.rowCount = rowCount;
        this.columnEps = columnEps;
    }

    public void verifyEpInfo() {
        for (Map.Entry<String, FileColumnProperties> entry : this.columnEps.entrySet()) {
            String colName = entry.getKey();
            FileColumnProperties colEp = entry.getValue();
            if (colEp.getNullCount() > this.rowCount) {
                throw new SFException(ErrorCode.INTERNAL_ERROR, String.format("Null count bigger than total row count on col=%s, nullCount=%s, rowCount=%s", colName, colEp.getNullCount(), this.rowCount));
            }
            if (colEp.getDistinctValues() == -1L) continue;
            throw new SFException(ErrorCode.INTERNAL_ERROR, String.format("Unexpected NDV on col=%s, value=%d", colName, colEp.getDistinctValues()));
        }
    }

    @JsonProperty(value="rows")
    long getRowCount() {
        return this.rowCount;
    }

    @JsonProperty(value="rows")
    void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    @JsonProperty(value="columns")
    Map<String, FileColumnProperties> getColumnEps() {
        return this.columnEps;
    }

    @JsonProperty(value="columns")
    void setColumnEps(Map<String, FileColumnProperties> columnEps) {
        this.columnEps = columnEps;
    }
}

