/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.io.IOException;
import java.util.Calendar;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.ingest.connection.IngestResponseException;
import net.snowflake.ingest.streaming.internal.ChannelConfigureRequest;
import net.snowflake.ingest.streaming.internal.ChannelConfigureResponse;
import net.snowflake.ingest.streaming.internal.ClientConfigureRequest;
import net.snowflake.ingest.streaming.internal.ExternalVolumeLocation;
import net.snowflake.ingest.streaming.internal.FileLocationInfo;
import net.snowflake.ingest.streaming.internal.IStorageManager;
import net.snowflake.ingest.streaming.internal.SnowflakeServiceClient;
import net.snowflake.ingest.streaming.internal.StreamingIngestStorage;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;
import net.snowflake.ingest.utils.Utils;

class ExternalVolumeManager<T>
implements IStorageManager<T, ExternalVolumeLocation> {
    private final Map<String, StreamingIngestStorage<T, ExternalVolumeLocation>> externalVolumeMap;
    private final String clientName;
    private final String role;
    private final SnowflakeServiceClient snowflakeServiceClient;
    private final String clientPrefix;

    ExternalVolumeManager(boolean isTestMode, String role, String clientName, SnowflakeServiceClient snowflakeServiceClient) {
        this.role = role;
        this.clientName = clientName;
        this.snowflakeServiceClient = snowflakeServiceClient;
        this.externalVolumeMap = new ConcurrentHashMap<String, StreamingIngestStorage<T, ExternalVolumeLocation>>();
        try {
            this.clientPrefix = isTestMode ? "testPrefix" : this.snowflakeServiceClient.clientConfigure(new ClientConfigureRequest(role)).getClientPrefix();
        }
        catch (IOException | IngestResponseException e) {
            throw new SFException(e, ErrorCode.CLIENT_CONFIGURE_FAILURE, e.getMessage());
        }
    }

    @Override
    public StreamingIngestStorage<T, ExternalVolumeLocation> getStorage(String fullyQualifiedTableName) {
        StreamingIngestStorage<T, ExternalVolumeLocation> stage = this.externalVolumeMap.get(fullyQualifiedTableName);
        if (stage == null) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, String.format("No external volume found for table %s", fullyQualifiedTableName));
        }
        return stage;
    }

    @Override
    public void addStorage(String dbName, String schemaName, String tableName, FileLocationInfo fileLocationInfo) {
        String fullyQualifiedTableName = Utils.getFullyQualifiedTableName(dbName, schemaName, tableName);
        try {
            this.externalVolumeMap.put(fullyQualifiedTableName, new StreamingIngestStorage(this, this.clientName, fileLocationInfo, new ExternalVolumeLocation(dbName, schemaName, tableName), 5));
        }
        catch (IOException | SnowflakeSQLException err) {
            throw new SFException(err, ErrorCode.UNABLE_TO_CONNECT_TO_STAGE, String.format("fullyQualifiedTableName=%s", fullyQualifiedTableName));
        }
    }

    @Override
    public FileLocationInfo getRefreshedLocation(ExternalVolumeLocation location, Optional<String> fileName) {
        try {
            ChannelConfigureRequest request = new ChannelConfigureRequest(this.role, location.dbName, location.schemaName, location.tableName);
            fileName.ifPresent(request::setFileName);
            ChannelConfigureResponse response = this.snowflakeServiceClient.channelConfigure(request);
            return response.getStageLocation();
        }
        catch (IOException | IngestResponseException e) {
            throw new SFException(e, ErrorCode.CHANNEL_CONFIGURE_FAILURE, e.getMessage());
        }
    }

    @Override
    public String generateBlobPath() {
        return "snow_dummy_file_name.parquet";
    }

    @Override
    public void decrementBlobSequencer() {
    }

    public String getBlobPath(Calendar calendar, String clientPrefix) {
        return "";
    }

    @Override
    public String getClientPrefix() {
        return this.clientPrefix;
    }
}

