/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import net.snowflake.ingest.internal.com.github.benmanes.caffeine.cache.Caffeine;
import net.snowflake.ingest.internal.com.github.benmanes.caffeine.cache.LoadingCache;

class LiteralQuoteUtils {
    static final int UNQUOTED_COLUMN_NAME_CACHE_MAX_SIZE = 30000;
    private static final LoadingCache<String, String> unquotedColumnNamesCache = Caffeine.newBuilder().maximumSize(30000L).build(LiteralQuoteUtils::unquoteColumnNameInternal);

    LiteralQuoteUtils() {
    }

    static String unquoteColumnName(String columnName) {
        return unquotedColumnNamesCache.get(columnName);
    }

    private static String unquoteColumnNameInternal(String columnName) {
        int length = columnName.length();
        if (length == 0) {
            return columnName;
        }
        if (columnName.charAt(0) == '\"' && length >= 2 && columnName.charAt(length - 1) == '\"' && !columnName.substring(1, length - 1).replace("\"\"", "").contains("\"")) {
            return columnName.substring(1, length - 1).replace("\"\"", "\"");
        }
        if (columnName.charAt(0) == '\"' && length >= 2 && columnName.charAt(length - 1) == '\"' && !columnName.substring(1, length - 1).contains("\"")) {
            return columnName.substring(1, length - 1);
        }
        if (columnName.contains("\\ ")) {
            columnName = columnName.replace("\\ ", " ");
        }
        return columnName.toUpperCase();
    }
}

