/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import net.snowflake.ingest.internal.fasterxml.jackson.annotation.JsonInclude;
import net.snowflake.ingest.internal.fasterxml.jackson.annotation.JsonProperty;
import net.snowflake.ingest.streaming.internal.IStreamingIngestRequest;
import net.snowflake.ingest.utils.Constants;

class OpenChannelRequestInternal
implements IStreamingIngestRequest {
    @JsonProperty(value="request_id")
    private String requestId;
    @JsonProperty(value="role")
    private String role;
    @JsonProperty(value="channel")
    private String channel;
    @JsonProperty(value="table")
    private String table;
    @JsonProperty(value="database")
    private String database;
    @JsonProperty(value="schema")
    private String schema;
    @JsonProperty(value="write_mode")
    private String writeMode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="offset_token")
    private String offsetToken;

    OpenChannelRequestInternal(String requestId, String role, String database, String schema, String table, String channel, Constants.WriteMode writeMode, String offsetToken) {
        this.requestId = requestId;
        this.role = role;
        this.database = database;
        this.schema = schema;
        this.table = table;
        this.channel = channel;
        this.writeMode = writeMode.name();
        this.offsetToken = offsetToken;
    }

    String getRequestId() {
        return this.requestId;
    }

    String getRole() {
        return this.role;
    }

    String getChannel() {
        return this.channel;
    }

    String getTable() {
        return this.table;
    }

    String getDatabase() {
        return this.database;
    }

    String getSchema() {
        return this.schema;
    }

    String getWriteMode() {
        return this.writeMode;
    }

    String getOffsetToken() {
        return this.offsetToken;
    }

    @Override
    public String getStringForLogging() {
        return String.format("OpenChannelRequestInternal(requestId=%s, role=%s, db=%s, schema=%s, table=%s, channel=%s, writeMode=%s)", this.requestId, this.role, this.database, this.schema, this.table, this.channel, this.writeMode);
    }
}

