/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.snowflake.ingest.internal.apache.parquet.schema.LogicalTypeAnnotation;
import net.snowflake.ingest.internal.apache.parquet.schema.PrimitiveType;
import net.snowflake.ingest.internal.apache.parquet.schema.Type;
import net.snowflake.ingest.internal.apache.parquet.schema.Types;
import net.snowflake.ingest.streaming.internal.AbstractRowBuffer;
import net.snowflake.ingest.streaming.internal.ColumnMetadata;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;

public class ParquetTypeGenerator {
    private static final Set<AbstractRowBuffer.ColumnPhysicalType> TIME_SUPPORTED_PHYSICAL_TYPES = new HashSet<AbstractRowBuffer.ColumnPhysicalType>(Arrays.asList(AbstractRowBuffer.ColumnPhysicalType.SB4, AbstractRowBuffer.ColumnPhysicalType.SB8));
    private static final Set<AbstractRowBuffer.ColumnPhysicalType> TIMESTAMP_SUPPORTED_PHYSICAL_TYPES = new HashSet<AbstractRowBuffer.ColumnPhysicalType>(Arrays.asList(AbstractRowBuffer.ColumnPhysicalType.SB8, AbstractRowBuffer.ColumnPhysicalType.SB16));

    static ParquetTypeInfo generateColumnParquetTypeInfo(ColumnMetadata column, int id) {
        Type parquetType;
        AbstractRowBuffer.ColumnLogicalType logicalType;
        AbstractRowBuffer.ColumnPhysicalType physicalType;
        id = column.getOrdinal() == null ? id : column.getOrdinal();
        ParquetTypeInfo res = new ParquetTypeInfo();
        HashMap<String, String> metadata = new HashMap<String, String>();
        String name = column.getInternalName();
        try {
            physicalType = AbstractRowBuffer.ColumnPhysicalType.valueOf(column.getPhysicalType());
            logicalType = AbstractRowBuffer.ColumnLogicalType.valueOf(column.getLogicalType());
        }
        catch (IllegalArgumentException e) {
            throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, column.getLogicalType(), column.getPhysicalType());
        }
        metadata.put(Integer.toString(id), logicalType.getOrdinal() + "," + physicalType.getOrdinal());
        Type.Repetition repetition = column.getNullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED;
        switch (logicalType) {
            case FIXED: {
                parquetType = ParquetTypeGenerator.getFixedColumnParquetType(column, id, physicalType, repetition);
                break;
            }
            case ARRAY: 
            case OBJECT: 
            case VARIANT: {
                metadata.put(id + ":obj_enc", "1");
            }
            case ANY: 
            case CHAR: 
            case TEXT: 
            case BINARY: {
                parquetType = (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(LogicalTypeAnnotation.stringType())).id(id)).named(name);
                break;
            }
            case TIMESTAMP_LTZ: 
            case TIMESTAMP_NTZ: 
            case TIMESTAMP_TZ: {
                parquetType = ParquetTypeGenerator.getTimeColumnParquetType(column.getScale(), physicalType, logicalType, TIMESTAMP_SUPPORTED_PHYSICAL_TYPES, repetition, id, name);
                break;
            }
            case DATE: {
                parquetType = (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(LogicalTypeAnnotation.dateType())).id(id)).named(name);
                break;
            }
            case TIME: {
                parquetType = ParquetTypeGenerator.getTimeColumnParquetType(column.getScale(), physicalType, logicalType, TIME_SUPPORTED_PHYSICAL_TYPES, repetition, id, name);
                break;
            }
            case BOOLEAN: {
                parquetType = (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition).id(id)).named(name);
                break;
            }
            case REAL: {
                parquetType = (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE, repetition).id(id)).named(name);
                break;
            }
            default: {
                throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, column.getLogicalType(), column.getPhysicalType());
            }
        }
        res.setParquetType(parquetType);
        res.setMetadata(metadata);
        return res;
    }

    private static Type getFixedColumnParquetType(ColumnMetadata column, int id, AbstractRowBuffer.ColumnPhysicalType physicalType, Type.Repetition repetition) {
        Type parquetType;
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation;
        String name = column.getInternalName();
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalTypeAnnotation2 = decimalLogicalTypeAnnotation = column.getScale() != null && column.getPrecision() != null ? LogicalTypeAnnotation.DecimalLogicalTypeAnnotation.decimalType(column.getScale(), column.getPrecision()) : null;
        if (column.getScale() != null && column.getScale() != 0 || physicalType == AbstractRowBuffer.ColumnPhysicalType.SB16) {
            parquetType = (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition).length(16)).as(decimalLogicalTypeAnnotation)).id(id)).named(name);
        } else {
            switch (physicalType) {
                case SB1: 
                case SB2: 
                case SB4: {
                    parquetType = (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(decimalLogicalTypeAnnotation)).id(id)).length(4)).named(name);
                    break;
                }
                case SB8: {
                    parquetType = (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(decimalLogicalTypeAnnotation)).id(id)).length(8)).named(name);
                    break;
                }
                default: {
                    throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, column.getLogicalType(), column.getPhysicalType());
                }
            }
        }
        return parquetType;
    }

    private static Type getTimeColumnParquetType(Integer scale, AbstractRowBuffer.ColumnPhysicalType physicalType, AbstractRowBuffer.ColumnLogicalType logicalType, Set<AbstractRowBuffer.ColumnPhysicalType> supportedPhysicalTypes, Type.Repetition repetition, int id, String name) {
        int length;
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation typeAnnotation;
        if (scale == null || scale > 9 || scale < 0 || !supportedPhysicalTypes.contains((Object)physicalType)) {
            throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, "Data type: " + (Object)((Object)logicalType) + ", " + (Object)((Object)physicalType) + ", scale: " + scale);
        }
        PrimitiveType.PrimitiveTypeName type = ParquetTypeGenerator.getTimePrimitiveType(physicalType);
        switch (physicalType) {
            case SB4: {
                typeAnnotation = LogicalTypeAnnotation.decimalType(scale, 9);
                length = 4;
                break;
            }
            case SB8: {
                typeAnnotation = LogicalTypeAnnotation.decimalType(scale, 18);
                length = 8;
                break;
            }
            case SB16: {
                typeAnnotation = LogicalTypeAnnotation.decimalType(scale, 38);
                length = 16;
                break;
            }
            default: {
                throw new SFException(ErrorCode.UNKNOWN_DATA_TYPE, new Object[]{logicalType, physicalType});
            }
        }
        return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(type, repetition).as(typeAnnotation)).length(length)).id(id)).named(name);
    }

    private static PrimitiveType.PrimitiveTypeName getTimePrimitiveType(AbstractRowBuffer.ColumnPhysicalType physicalType) {
        PrimitiveType.PrimitiveTypeName type;
        switch (physicalType) {
            case SB4: {
                type = PrimitiveType.PrimitiveTypeName.INT32;
                break;
            }
            case SB8: {
                type = PrimitiveType.PrimitiveTypeName.INT64;
                break;
            }
            case SB16: {
                type = PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Time physical type: " + (Object)((Object)physicalType));
            }
        }
        return type;
    }

    static class ParquetTypeInfo {
        private Type parquetType;
        private Map<String, String> metadata;

        ParquetTypeInfo() {
        }

        public Type getParquetType() {
            return this.parquetType;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public void setParquetType(Type parquetType) {
            this.parquetType = parquetType;
        }

        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        public PrimitiveType.PrimitiveTypeName getPrimitiveTypeName() {
            return this.parquetType.asPrimitiveType().getPrimitiveTypeName();
        }
    }
}

