/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.io.IOException;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.ingest.connection.IngestResponseException;
import net.snowflake.ingest.connection.RequestBuilder;
import net.snowflake.ingest.connection.ServiceResponseHandler;
import net.snowflake.ingest.streaming.internal.ChannelConfigureRequest;
import net.snowflake.ingest.streaming.internal.ChannelConfigureResponse;
import net.snowflake.ingest.streaming.internal.ChannelsStatusRequest;
import net.snowflake.ingest.streaming.internal.ChannelsStatusResponse;
import net.snowflake.ingest.streaming.internal.ClientConfigureRequest;
import net.snowflake.ingest.streaming.internal.ClientConfigureResponse;
import net.snowflake.ingest.streaming.internal.DropChannelRequestInternal;
import net.snowflake.ingest.streaming.internal.DropChannelResponse;
import net.snowflake.ingest.streaming.internal.IStreamingIngestRequest;
import net.snowflake.ingest.streaming.internal.OpenChannelRequestInternal;
import net.snowflake.ingest.streaming.internal.OpenChannelResponse;
import net.snowflake.ingest.streaming.internal.RegisterBlobRequest;
import net.snowflake.ingest.streaming.internal.RegisterBlobResponse;
import net.snowflake.ingest.streaming.internal.StreamingIngestResponse;
import net.snowflake.ingest.streaming.internal.StreamingIngestUtils;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.Logging;
import net.snowflake.ingest.utils.SFException;

class SnowflakeServiceClient {
    private static final Logging logger = new Logging(SnowflakeServiceClient.class);
    private final CloseableHttpClient httpClient;
    private final RequestBuilder requestBuilder;

    SnowflakeServiceClient(CloseableHttpClient httpClient, RequestBuilder requestBuilder) {
        this.httpClient = httpClient;
        this.requestBuilder = requestBuilder;
    }

    ClientConfigureResponse clientConfigure(ClientConfigureRequest request) throws IngestResponseException, IOException {
        ClientConfigureResponse response = this.executeApiRequestWithRetries(ClientConfigureResponse.class, request, "/v1/streaming/client/configure/", "client configure", ServiceResponseHandler.ApiName.STREAMING_CLIENT_CONFIGURE);
        if (response.getStatusCode() != 0L) {
            logger.logDebug("Client configure request failed, request={}, message={}", request.getStringForLogging(), response.getMessage());
            throw new SFException(ErrorCode.CLIENT_CONFIGURE_FAILURE, response.getMessage());
        }
        return response;
    }

    ChannelConfigureResponse channelConfigure(ChannelConfigureRequest request) throws IngestResponseException, IOException {
        ChannelConfigureResponse response = this.executeApiRequestWithRetries(ChannelConfigureResponse.class, request, "/v1/streaming/channels/configure/", "channel configure", ServiceResponseHandler.ApiName.STREAMING_CHANNEL_CONFIGURE);
        if (response.getStatusCode() != 0L) {
            logger.logDebug("Channel configure request failed, request={}, response={}", request.getStringForLogging(), response.getMessage());
            throw new SFException(ErrorCode.CHANNEL_CONFIGURE_FAILURE, response.getMessage());
        }
        return response;
    }

    OpenChannelResponse openChannel(OpenChannelRequestInternal request) throws IngestResponseException, IOException {
        OpenChannelResponse response = this.executeApiRequestWithRetries(OpenChannelResponse.class, request, "/v1/streaming/channels/open/", "open channel", ServiceResponseHandler.ApiName.STREAMING_OPEN_CHANNEL);
        if (response.getStatusCode() != 0L) {
            logger.logDebug("Open channel request failed, request={}, response={}", request.getStringForLogging(), response.getMessage());
            throw new SFException(ErrorCode.OPEN_CHANNEL_FAILURE, response.getMessage());
        }
        return response;
    }

    DropChannelResponse dropChannel(DropChannelRequestInternal request) throws IngestResponseException, IOException {
        DropChannelResponse response = this.executeApiRequestWithRetries(DropChannelResponse.class, request, "/v1/streaming/channels/drop/", "drop channel", ServiceResponseHandler.ApiName.STREAMING_DROP_CHANNEL);
        if (response.getStatusCode() != 0L) {
            logger.logDebug("Drop channel request failed, request={}, response={}", request.getStringForLogging(), response.getMessage());
            throw new SFException(ErrorCode.DROP_CHANNEL_FAILURE, response.getMessage());
        }
        return response;
    }

    ChannelsStatusResponse getChannelStatus(ChannelsStatusRequest request) throws IngestResponseException, IOException {
        ChannelsStatusResponse response = this.executeApiRequestWithRetries(ChannelsStatusResponse.class, request, "/v1/streaming/channels/status/", "channel status", ServiceResponseHandler.ApiName.STREAMING_CHANNEL_STATUS);
        if (response.getStatusCode() != 0L) {
            logger.logDebug("Channel status request failed, request={}, response={}", request.getStringForLogging(), response.getMessage());
            throw new SFException(ErrorCode.CHANNEL_STATUS_FAILURE, response.getMessage());
        }
        return response;
    }

    RegisterBlobResponse registerBlob(RegisterBlobRequest request, int executionCount) throws IngestResponseException, IOException {
        RegisterBlobResponse response = this.executeApiRequestWithRetries(RegisterBlobResponse.class, request, "/v1/streaming/channels/write/blobs/", "register blob", ServiceResponseHandler.ApiName.STREAMING_REGISTER_BLOB);
        if (response.getStatusCode() != 0L) {
            logger.logDebug("Register blob request failed, request={}, response={}, executionCount={}", request.getStringForLogging(), response.getMessage(), executionCount);
            throw new SFException(ErrorCode.REGISTER_BLOB_FAILURE, response.getMessage());
        }
        return response;
    }

    private <T extends StreamingIngestResponse> T executeApiRequestWithRetries(Class<T> responseClass, IStreamingIngestRequest request, String endpoint, String operation, ServiceResponseHandler.ApiName apiName) throws IngestResponseException, IOException {
        return StreamingIngestUtils.executeWithRetries(responseClass, endpoint, request, operation, apiName, this.httpClient, this.requestBuilder);
    }
}

