/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.snowflake.ingest.internal.com.google.common.annotations.VisibleForTesting;
import net.snowflake.ingest.internal.javax.annotation.Nullable;
import net.snowflake.ingest.streaming.DropChannelRequest;
import net.snowflake.ingest.streaming.InsertValidationResponse;
import net.snowflake.ingest.streaming.OffsetTokenVerificationFunction;
import net.snowflake.ingest.streaming.OpenChannelRequest;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestChannel;
import net.snowflake.ingest.streaming.internal.AbstractRowBuffer;
import net.snowflake.ingest.streaming.internal.ChannelData;
import net.snowflake.ingest.streaming.internal.ChannelFlushContext;
import net.snowflake.ingest.streaming.internal.ChannelRuntimeState;
import net.snowflake.ingest.streaming.internal.ChannelsStatusResponse;
import net.snowflake.ingest.streaming.internal.ClientBufferParameters;
import net.snowflake.ingest.streaming.internal.ColumnMetadata;
import net.snowflake.ingest.streaming.internal.ColumnProperties;
import net.snowflake.ingest.streaming.internal.DropChannelVersionRequest;
import net.snowflake.ingest.streaming.internal.MemoryInfoProvider;
import net.snowflake.ingest.streaming.internal.MemoryInfoProviderFromRuntime;
import net.snowflake.ingest.streaming.internal.RowBuffer;
import net.snowflake.ingest.streaming.internal.SnowflakeStreamingIngestClientInternal;
import net.snowflake.ingest.utils.Constants;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.Logging;
import net.snowflake.ingest.utils.SFException;
import net.snowflake.ingest.utils.Utils;

class SnowflakeStreamingIngestChannelInternal<T>
implements SnowflakeStreamingIngestChannel {
    private static final Logging logger = new Logging(SnowflakeStreamingIngestChannelInternal.class);
    private final ChannelFlushContext channelFlushContext;
    private final RowBuffer<T> rowBuffer;
    private final long insertThrottleIntervalInMs;
    private final int insertThrottleThresholdInBytes;
    private final int insertThrottleThresholdInPercentage;
    private final long maxMemoryLimitInBytes;
    private volatile boolean isClosed = false;
    private final SnowflakeStreamingIngestClientInternal<T> owningClient;
    private final ChannelRuntimeState channelState;
    private final Map<String, ColumnProperties> tableColumns;
    private String invalidationCause;
    private final MemoryInfoProvider memoryInfoProvider;
    private volatile long freeMemoryInBytes = 0L;

    SnowflakeStreamingIngestChannelInternal(String name, String dbName, String schemaName, String tableName, String offsetToken, Long channelSequencer, Long rowSequencer, SnowflakeStreamingIngestClientInternal<T> client, String encryptionKey, Long encryptionKeyId, OpenChannelRequest.OnErrorOption onErrorOption, ZoneOffset defaultTimezone) {
        this(name, dbName, schemaName, tableName, offsetToken, channelSequencer, rowSequencer, client, encryptionKey, encryptionKeyId, onErrorOption, defaultTimezone, client.getParameterProvider().getBlobFormatVersion(), null);
    }

    SnowflakeStreamingIngestChannelInternal(String name, String dbName, String schemaName, String tableName, String endOffsetToken, Long channelSequencer, Long rowSequencer, SnowflakeStreamingIngestClientInternal<T> client, String encryptionKey, Long encryptionKeyId, OpenChannelRequest.OnErrorOption onErrorOption, ZoneId defaultTimezone, Constants.BdecVersion bdecVersion, OffsetTokenVerificationFunction offsetTokenVerificationFunction) {
        this.owningClient = client;
        this.insertThrottleIntervalInMs = this.owningClient.getParameterProvider().getInsertThrottleIntervalInMs();
        this.insertThrottleThresholdInBytes = this.owningClient.getParameterProvider().getInsertThrottleThresholdInBytes();
        this.insertThrottleThresholdInPercentage = this.owningClient.getParameterProvider().getInsertThrottleThresholdInPercentage();
        this.maxMemoryLimitInBytes = this.owningClient.getParameterProvider().getMaxMemoryLimitInBytes();
        this.memoryInfoProvider = MemoryInfoProviderFromRuntime.getInstance();
        this.channelFlushContext = new ChannelFlushContext(name, dbName, schemaName, tableName, channelSequencer, encryptionKey, encryptionKeyId);
        this.channelState = new ChannelRuntimeState(endOffsetToken, rowSequencer, true);
        this.rowBuffer = AbstractRowBuffer.createRowBuffer(onErrorOption, defaultTimezone, bdecVersion, this.getFullyQualifiedName(), this::collectRowSize, this.channelState, new ClientBufferParameters(this.owningClient), offsetTokenVerificationFunction, this.owningClient == null ? null : this.owningClient.getTelemetryService());
        this.tableColumns = new HashMap<String, ColumnProperties>();
        logger.logInfo("Channel={} created for table={}", this.channelFlushContext.getName(), this.channelFlushContext.getTableName());
    }

    @Override
    public String getFullyQualifiedName() {
        return this.channelFlushContext.getFullyQualifiedName();
    }

    @Override
    public String getName() {
        return this.channelFlushContext.getName();
    }

    @Override
    public String getDBName() {
        return this.channelFlushContext.getDbName();
    }

    @Override
    public String getSchemaName() {
        return this.channelFlushContext.getSchemaName();
    }

    @Override
    public String getTableName() {
        return this.channelFlushContext.getTableName();
    }

    Long getChannelSequencer() {
        return this.channelFlushContext.getChannelSequencer();
    }

    @VisibleForTesting
    ChannelRuntimeState getChannelState() {
        return this.channelState;
    }

    @Override
    public String getFullyQualifiedTableName() {
        return this.channelFlushContext.getFullyQualifiedTableName();
    }

    ChannelData<T> getData(String filePath) {
        ChannelData<T> data = this.rowBuffer.flush(filePath);
        if (data != null) {
            data.setChannelContext(this.channelFlushContext);
        }
        return data;
    }

    @Override
    public boolean isValid() {
        return this.channelState.isValid();
    }

    void invalidate(String message, String invalidationCause) {
        this.channelState.invalidate();
        this.invalidationCause = invalidationCause;
        this.rowBuffer.close("invalidate");
        logger.logWarn("Channel is invalidated, name={}, channel sequencer={}, row sequencer={}, message={}", this.getFullyQualifiedName(), this.channelFlushContext.getChannelSequencer(), this.channelState.getRowSequencer(), message);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    void markClosed() {
        this.isClosed = true;
        logger.logInfo("Channel is marked as closed, name={}, channel sequencer={}, row sequencer={}", this.getFullyQualifiedName(), this.channelFlushContext.getChannelSequencer(), this.channelState.getRowSequencer());
    }

    CompletableFuture<Void> flush(boolean closing) {
        if (this.isClosed() && !closing) {
            throw new SFException(ErrorCode.CLOSED_CHANNEL, this.getFullyQualifiedName());
        }
        if (this.rowBuffer.getSize() == 0.0f) {
            return CompletableFuture.completedFuture(null);
        }
        return this.owningClient.flush(false);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.close(false);
    }

    @Override
    public CompletableFuture<Void> close(boolean drop) {
        this.checkValidation();
        if (this.isClosed()) {
            return CompletableFuture.completedFuture(null);
        }
        this.markClosed();
        return this.flush(true).thenRunAsync(() -> {
            List<SnowflakeStreamingIngestChannelInternal<?>> uncommittedChannels = this.owningClient.verifyChannelsAreFullyCommitted(Collections.singletonList(this));
            this.rowBuffer.close("close");
            this.owningClient.removeChannelIfSequencersMatch(this);
            if (!this.isValid() || !uncommittedChannels.isEmpty()) {
                throw new SFException(ErrorCode.CHANNELS_WITH_UNCOMMITTED_ROWS, uncommittedChannels.stream().map(SnowflakeStreamingIngestChannelInternal::getFullyQualifiedName).collect(Collectors.toList()));
            }
            if (drop) {
                DropChannelRequest.DropChannelRequestBuilder builder = DropChannelRequest.builder(this.getChannelContext().getName()).setDBName(this.getDBName()).setTableName(this.getTableName()).setSchemaName(this.getSchemaName());
                this.owningClient.dropChannel(new DropChannelVersionRequest(builder, this.getChannelSequencer()));
            }
        });
    }

    void setupSchema(List<ColumnMetadata> columns) {
        logger.logDebug("Setup schema for channel={}, schema={}", this.getFullyQualifiedName(), columns);
        this.rowBuffer.setupSchema(columns);
        columns.forEach(c -> this.tableColumns.putIfAbsent(c.getName(), new ColumnProperties((ColumnMetadata)c)));
    }

    @Override
    public InsertValidationResponse insertRow(Map<String, Object> row, String offsetToken) {
        return this.insertRows(Collections.singletonList(row), offsetToken, offsetToken);
    }

    @Override
    public InsertValidationResponse insertRows(Iterable<Map<String, Object>> rows, @Nullable String startOffsetToken, @Nullable String endOffsetToken) {
        this.throttleInsertIfNeeded(this.memoryInfoProvider);
        this.checkValidation();
        if (this.isClosed()) {
            throw new SFException(ErrorCode.CLOSED_CHANNEL, this.getFullyQualifiedName());
        }
        LinkedList<Map<String, Object>> rowsCopy = new LinkedList<Map<String, Object>>();
        rows.forEach(r -> rowsCopy.add(new LinkedHashMap(r)));
        InsertValidationResponse response = this.rowBuffer.insertRows(rowsCopy, startOffsetToken, endOffsetToken);
        if (this.rowBuffer.getSize() >= (float)this.owningClient.getParameterProvider().getMaxChannelSizeInBytes()) {
            this.owningClient.setNeedFlush(this.channelFlushContext.getFullyQualifiedTableName());
        }
        return response;
    }

    @Override
    public InsertValidationResponse insertRows(Iterable<Map<String, Object>> rows, String offsetToken) {
        return this.insertRows(rows, null, offsetToken);
    }

    void collectRowSize(float rowSize) {
        if (this.owningClient.inputThroughput != null) {
            this.owningClient.inputThroughput.mark((long)rowSize);
        }
    }

    @Override
    public String getLatestCommittedOffsetToken() {
        this.checkValidation();
        ChannelsStatusResponse.ChannelStatusResponseDTO response = this.owningClient.getChannelsStatus(Collections.singletonList(this)).getChannels().get(0);
        if (response.getStatusCode() != 0L) {
            throw new SFException(ErrorCode.CHANNEL_STATUS_INVALID, this.getName(), response.getStatusCode());
        }
        return response.getPersistedOffsetToken();
    }

    @Override
    public Map<String, ColumnProperties> getTableSchema() {
        return this.tableColumns;
    }

    void throttleInsertIfNeeded(MemoryInfoProvider memoryInfoProvider) {
        int retry;
        for (retry = 0; (this.hasLowRuntimeMemory(memoryInfoProvider) || this.owningClient.getFlushService() != null && this.owningClient.getFlushService().throttleDueToQueuedFlushTasks()) && retry < 60; ++retry) {
            try {
                Thread.sleep(this.insertThrottleIntervalInMs);
                continue;
            }
            catch (InterruptedException e) {
                throw new SFException(ErrorCode.INTERNAL_ERROR, "Insert throttle get interrupted");
            }
        }
        if (retry > 0) {
            logger.logInfo("Insert throttled for a total of {} milliseconds, retryCount={}, client={}, channel={}", (long)retry * this.insertThrottleIntervalInMs, retry, this.owningClient.getName(), this.getFullyQualifiedName());
        }
    }

    private boolean hasLowRuntimeMemory(MemoryInfoProvider memoryInfoProvider) {
        boolean hasLowRuntimeMemory;
        long maxMemory = this.maxMemoryLimitInBytes == -1L ? memoryInfoProvider.getMaxMemory() : this.maxMemoryLimitInBytes;
        this.freeMemoryInBytes = memoryInfoProvider.getFreeMemory();
        boolean bl = hasLowRuntimeMemory = this.freeMemoryInBytes < (long)this.insertThrottleThresholdInBytes && this.freeMemoryInBytes * 100L / maxMemory < (long)this.insertThrottleThresholdInPercentage;
        if (hasLowRuntimeMemory) {
            logger.logWarn("Throttled due to memory pressure, client={}, channel={}.", this.owningClient.getName(), this.getFullyQualifiedName());
            Utils.showMemory();
        }
        return hasLowRuntimeMemory;
    }

    private void checkValidation() {
        if (!this.isValid()) {
            this.owningClient.removeChannelIfSequencersMatch(this);
            this.rowBuffer.close("checkValidation");
            throw new SFException(ErrorCode.INVALID_CHANNEL, this.getFullyQualifiedName(), this.invalidationCause);
        }
    }

    RowBuffer<T> getRowBuffer() {
        return this.rowBuffer;
    }

    @VisibleForTesting
    public ChannelFlushContext getChannelContext() {
        return this.channelFlushContext;
    }
}

