/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferConfig;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadata;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.internal.apache.commons.io.FileUtils;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.ingest.internal.com.google.common.annotations.VisibleForTesting;
import net.snowflake.ingest.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.ingest.streaming.internal.FileLocationInfo;
import net.snowflake.ingest.streaming.internal.IStorageManager;
import net.snowflake.ingest.streaming.internal.StreamingIngestUtils;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.HttpUtil;
import net.snowflake.ingest.utils.Logging;
import net.snowflake.ingest.utils.SFException;
import net.snowflake.ingest.utils.Utils;

class StreamingIngestStorage<T, TLocation> {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper parseConfigureResponseMapper = new net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper();
    private static final long REFRESH_THRESHOLD_IN_MS = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);
    private static final Duration refreshDuration = Duration.ofMinutes(58L);
    private static Instant prevRefresh = Instant.EPOCH;
    private static final Logging logger = new Logging(StreamingIngestStorage.class);
    private SnowflakeFileTransferMetadataWithAge fileTransferMetadataWithAge;
    private final IStorageManager<T, TLocation> owningManager;
    private final TLocation location;
    private final String clientName;
    private final int maxUploadRetries;
    private final Properties proxyProperties;

    StreamingIngestStorage(IStorageManager<T, TLocation> owningManager, String clientName, FileLocationInfo fileLocationInfo, TLocation location, int maxUploadRetries) throws SnowflakeSQLException, IOException {
        this(owningManager, clientName, (SnowflakeFileTransferMetadataWithAge)null, location, maxUploadRetries);
        super.createFileTransferMetadataWithAge(fileLocationInfo);
    }

    StreamingIngestStorage(IStorageManager<T, TLocation> owningManager, String clientName, SnowflakeFileTransferMetadataWithAge testMetadata, TLocation location, int maxUploadRetries) throws SnowflakeSQLException, IOException {
        this.owningManager = owningManager;
        this.clientName = clientName;
        this.maxUploadRetries = maxUploadRetries;
        this.proxyProperties = HttpUtil.generateProxyPropertiesForJDBC();
        this.location = location;
        this.fileTransferMetadataWithAge = testMetadata;
    }

    void putRemote(String fullFilePath, byte[] data) throws SnowflakeSQLException, IOException {
        this.putRemote(fullFilePath, data, 0);
    }

    private void putRemote(String fullFilePath, byte[] data, int retryCount) throws SnowflakeSQLException, IOException {
        SnowflakeFileTransferMetadataV1 fileTransferMetadataCopy;
        if (this.fileTransferMetadataWithAge.fileTransferMetadata.isForOneFile()) {
            fileTransferMetadataCopy = this.fetchSignedURL(fullFilePath);
        } else {
            SnowflakeFileTransferMetadataV1 fileTransferMetadata = this.fileTransferMetadataWithAge.fileTransferMetadata;
            fileTransferMetadataCopy = new SnowflakeFileTransferMetadataV1(fileTransferMetadata.getPresignedUrl(), fullFilePath, fileTransferMetadata.getEncryptionMaterial() != null ? fileTransferMetadata.getEncryptionMaterial().getQueryStageMasterKey() : null, fileTransferMetadata.getEncryptionMaterial() != null ? fileTransferMetadata.getEncryptionMaterial().getQueryId() : null, fileTransferMetadata.getEncryptionMaterial() != null ? fileTransferMetadata.getEncryptionMaterial().getSmkId() : null, fileTransferMetadata.getCommandType(), fileTransferMetadata.getStageInfo());
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        try {
            if (Instant.now().isAfter(prevRefresh.plus(refreshDuration))) {
                this.refreshSnowflakeMetadata();
            }
            SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata((SnowflakeFileTransferMetadata)fileTransferMetadataCopy).setUploadStream((InputStream)inStream).setRequireCompress(false).setOcspMode(OCSPMode.FAIL_OPEN).setStreamingIngestClientKey(this.owningManager.getClientPrefix()).setStreamingIngestClientName(this.clientName).setProxyProperties(this.proxyProperties).setDestFileName(fullFilePath).build());
        }
        catch (Exception e) {
            if (retryCount == 0) {
                this.refreshSnowflakeMetadata();
            }
            if (retryCount >= this.maxUploadRetries) {
                logger.logError("Failed to upload to stage, retry attempts exhausted ({}), client={}, message={}", this.maxUploadRetries, this.clientName, e.getMessage());
                throw new SFException(e, ErrorCode.IO_ERROR, new Object[0]);
            }
            StreamingIngestUtils.sleepForRetry(++retryCount);
            logger.logInfo("Retrying upload, attempt {}/{} msg: {}, stackTrace:{}", retryCount, this.maxUploadRetries, e.getMessage(), Utils.getStackTrace(e));
            this.putRemote(fullFilePath, data, retryCount);
        }
    }

    SnowflakeFileTransferMetadataWithAge refreshSnowflakeMetadata() throws SnowflakeSQLException, IOException {
        logger.logInfo("Refresh Snowflake metadata, client={}", this.clientName);
        return this.refreshSnowflakeMetadata(false);
    }

    synchronized SnowflakeFileTransferMetadataWithAge refreshSnowflakeMetadata(boolean force) throws SnowflakeSQLException, IOException {
        if (!force && this.fileTransferMetadataWithAge != null && this.fileTransferMetadataWithAge.timestamp.isPresent() && this.fileTransferMetadataWithAge.timestamp.get() > System.currentTimeMillis() - REFRESH_THRESHOLD_IN_MS) {
            return this.fileTransferMetadataWithAge;
        }
        FileLocationInfo location = this.owningManager.getRefreshedLocation(this.location, Optional.empty());
        return this.createFileTransferMetadataWithAge(location);
    }

    private SnowflakeFileTransferMetadataWithAge createFileTransferMetadataWithAge(FileLocationInfo fileLocationInfo) throws JsonProcessingException, net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException, SnowflakeSQLException {
        Utils.assertStringNotNullOrEmpty("client prefix", this.owningManager.getClientPrefix());
        this.fileTransferMetadataWithAge = fileLocationInfo.getLocationType().replaceAll("^[\"]|[\"]$", "").equals(StageInfo.StageType.LOCAL_FS.name()) ? new SnowflakeFileTransferMetadataWithAge(fileLocationInfo.getLocation().replaceAll("^[\"]|[\"]$", ""), Optional.of(System.currentTimeMillis())) : new SnowflakeFileTransferMetadataWithAge((SnowflakeFileTransferMetadataV1)SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)this.parseFileLocationInfo(fileLocationInfo)).get(0), Optional.of(System.currentTimeMillis()));
        prevRefresh = Instant.now();
        return this.fileTransferMetadataWithAge;
    }

    SnowflakeFileTransferMetadataV1 fetchSignedURL(String fileName) throws SnowflakeSQLException, IOException {
        FileLocationInfo location = this.owningManager.getRefreshedLocation(this.location, Optional.of(fileName));
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)this.parseFileLocationInfo(location)).get(0);
        metadata.setPresignedUrlFileName(fileName);
        return metadata;
    }

    private JsonNode parseFileLocationInfo(FileLocationInfo fileLocationInfo) throws JsonProcessingException, net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException {
        Object fileLocationInfoNode = mapper.valueToTree(fileLocationInfo);
        ObjectNode node = mapper.createObjectNode();
        node.putObject("data");
        ObjectNode dataNode = (ObjectNode)node.get("data");
        dataNode.set("stageInfo", (net.snowflake.ingest.internal.fasterxml.jackson.databind.JsonNode)fileLocationInfoNode);
        dataNode.putArray("src_locations").add("placeholder");
        String responseString = mapper.writeValueAsString(node);
        return parseConfigureResponseMapper.readTree(responseString);
    }

    void put(String filePath, byte[] blob) {
        if (this.isLocalFS()) {
            this.putLocal(filePath, blob);
        } else {
            try {
                this.putRemote(filePath, blob);
            }
            catch (IOException | SnowflakeSQLException e) {
                throw new SFException(e, ErrorCode.BLOB_UPLOAD_FAILURE, new Object[0]);
            }
        }
    }

    boolean isLocalFS() {
        return this.fileTransferMetadataWithAge.isLocalFS;
    }

    @VisibleForTesting
    void putLocal(String fullFilePath, byte[] data) {
        if (fullFilePath == null || fullFilePath.isEmpty() || fullFilePath.endsWith("/")) {
            throw new SFException(ErrorCode.BLOB_UPLOAD_FAILURE, new Object[0]);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        try {
            String stageLocation = this.fileTransferMetadataWithAge.localLocation;
            File destFile = Paths.get(stageLocation, fullFilePath).toFile();
            FileUtils.copyInputStreamToFile((InputStream)input, (File)destFile);
        }
        catch (Exception ex) {
            throw new SFException(ex, ErrorCode.BLOB_UPLOAD_FAILURE, new Object[0]);
        }
    }

    static class SnowflakeFileTransferMetadataWithAge {
        SnowflakeFileTransferMetadataV1 fileTransferMetadata;
        private final boolean isLocalFS;
        private final String localLocation;
        Optional<Long> timestamp;

        SnowflakeFileTransferMetadataWithAge(SnowflakeFileTransferMetadataV1 fileTransferMetadata, Optional<Long> timestamp) {
            this.isLocalFS = false;
            this.fileTransferMetadata = fileTransferMetadata;
            this.timestamp = timestamp;
            this.localLocation = null;
        }

        SnowflakeFileTransferMetadataWithAge(String localLocation, Optional<Long> timestamp) {
            this.isLocalFS = true;
            this.localLocation = localLocation;
            this.timestamp = timestamp;
        }
    }
}

