/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import net.snowflake.client.jdbc.internal.snowflake.common.core.ResourceBundleManager;
import net.snowflake.ingest.utils.ErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFException
extends RuntimeException {
    static final Logger logger = LoggerFactory.getLogger(SFException.class);
    static final ResourceBundleManager errorResourceBundleManager = ResourceBundleManager.getSingleton((String)"net.snowflake.ingest.ingest_error_messages");
    private Throwable cause;
    private String vendorCode;
    private Object[] params;

    public SFException(Throwable cause, ErrorCode errorCode, Object ... params) {
        super(errorResourceBundleManager.getLocalizedMessage(String.valueOf(errorCode.getMessageCode()), params), cause);
        this.vendorCode = errorCode.getMessageCode();
        this.params = params;
        this.cause = cause;
    }

    public SFException(ErrorCode errorCode, Object ... params) {
        this(null, errorCode, params);
    }

    public String getVendorCode() {
        return this.vendorCode;
    }

    public Object[] getParams() {
        return this.params;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }
}

