/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.snowflake.client.jdbc.internal.apache.http.HttpEntity;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpUriRequest;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.entity.ContentType;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.util.EntityUtils;
import net.snowflake.client.jdbc.internal.google.gson.JsonObject;
import net.snowflake.client.jdbc.internal.google.gson.JsonParser;
import net.snowflake.ingest.connection.OAuthCredential;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.HttpUtil;
import net.snowflake.ingest.utils.SFException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthClient {
    static final Logger LOGGER = LoggerFactory.getLogger(OAuthClient.class);
    private static final String TOKEN_REQUEST_ENDPOINT = "/oauth/token-request";
    private static final String OAUTH_CONTENT_TYPE_HEADER = "application/x-www-form-urlencoded";
    private static final String GRANT_TYPE_PARAM = "grant_type";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String EXPIRES_IN = "expires_in";
    private final AtomicReference<OAuthCredential> oAuthCredential;
    private final CloseableHttpClient httpClient;

    OAuthClient(String accountName, OAuthCredential oAuthCredential, URIBuilder baseURIBuilder) {
        this.oAuthCredential = new AtomicReference<OAuthCredential>(oAuthCredential);
        baseURIBuilder.setPath(TOKEN_REQUEST_ENDPOINT);
        this.httpClient = HttpUtil.getHttpClient(accountName);
    }

    public AtomicReference<OAuthCredential> getOAuthCredentialRef() {
        return this.oAuthCredential;
    }

    public void refreshToken() throws IOException {
        JsonObject respBody;
        CloseableHttpResponse httpResponse = this.httpClient.execute(this.makeRefreshTokenRequest());
        String respBodyString = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        if (httpResponse.getStatusLine().getStatusCode() == 200 && (respBody = JsonParser.parseString((String)respBodyString).getAsJsonObject()).has(ACCESS_TOKEN) && respBody.has(EXPIRES_IN)) {
            String newAccessToken = respBody.get(ACCESS_TOKEN).toString().replaceAll("^\"|\"$", "");
            this.oAuthCredential.get().setAccessToken(newAccessToken);
            this.oAuthCredential.get().setExpiresIn(respBody.get(EXPIRES_IN).getAsInt());
            return;
        }
        throw new SFException(ErrorCode.OAUTH_REFRESH_TOKEN_ERROR, "Refresh access token fail with response: " + respBodyString);
    }

    private HttpUriRequest makeRefreshTokenRequest() {
        HttpPost post = new HttpPost(this.oAuthCredential.get().getOAuthTokenEndpoint());
        post.addHeader("Content-Type", OAUTH_CONTENT_TYPE_HEADER);
        post.addHeader("Authorization", this.oAuthCredential.get().getAuthHeader());
        HashMap<String, String> payload = new HashMap<String, String>();
        try {
            payload.put(GRANT_TYPE_PARAM, URLEncoder.encode(REFRESH_TOKEN, "UTF-8"));
            payload.put(REFRESH_TOKEN, URLEncoder.encode(this.oAuthCredential.get().getRefreshToken(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e2) {
            throw new SFException(e2, ErrorCode.OAUTH_REFRESH_TOKEN_ERROR, e2.getMessage());
        }
        String payloadString = payload.entrySet().stream().map(e -> e.getKey() + "=" + e.getValue()).collect(Collectors.joining("&"));
        post.setEntity((HttpEntity)new StringEntity(payloadString, ContentType.APPLICATION_FORM_URLENCODED));
        return post;
    }
}

