/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.ingest.connection.OAuthClient;
import net.snowflake.ingest.connection.OAuthCredential;
import net.snowflake.ingest.connection.SecurityManager;
import net.snowflake.ingest.connection.TelemetryService;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;

public final class OAuthManager
extends SecurityManager {
    private static final double DEFAULT_UPDATE_THRESHOLD_RATIO = 0.8;
    private static final String TOKEN_REQUEST_ENDPOINT = "/oauth/token-request";
    private static final String OAUTH_CONTENT_TYPE_HEADER = "application/x-www-form-urlencoded";
    private static final String TOKEN_TYPE = "OAUTH";
    private final double updateThresholdRatio;
    private OAuthClient oAuthClient;

    OAuthManager(String accountName, String username, OAuthCredential oAuthCredential, URIBuilder baseURIBuilder, TelemetryService telemetryService) {
        this(accountName, username, oAuthCredential, baseURIBuilder, 0.8, telemetryService);
    }

    OAuthManager(String accountName, String username, OAuthCredential oAuthCredential, URIBuilder baseURIBuilder, double updateThresholdRatio, TelemetryService telemetryService) {
        super(accountName, username, null);
        if (oAuthCredential == null || baseURIBuilder == null) {
            throw new IllegalArgumentException();
        }
        if (updateThresholdRatio <= 0.0 || updateThresholdRatio >= 1.0) {
            throw new IllegalArgumentException("updateThresholdRatio should fall in (0, 1)");
        }
        this.updateThresholdRatio = updateThresholdRatio;
        this.oAuthClient = new OAuthClient(accountName, oAuthCredential, baseURIBuilder);
        this.refreshToken();
    }

    public OAuthManager(String accountName, String username, OAuthClient oAuthClient, double updateThresholdRatio) {
        super(accountName, username, null);
        this.updateThresholdRatio = updateThresholdRatio;
        this.oAuthClient = oAuthClient;
        this.refreshToken();
    }

    @Override
    String getToken() {
        if (this.refreshFailed.get()) {
            throw new SecurityException("getToken request failed due to token refresh failure");
        }
        return this.oAuthClient.getOAuthCredentialRef().get().getAccessToken();
    }

    @Override
    String getTokenType() {
        return TOKEN_TYPE;
    }

    void setRefreshToken(String refreshToken) {
        this.oAuthClient.getOAuthCredentialRef().get().setRefreshToken(refreshToken);
    }

    @Override
    void refreshToken() {
        for (int retries = 0; retries < 3; ++retries) {
            try {
                this.oAuthClient.refreshToken();
                long nextRefreshDelay = (long)((double)this.oAuthClient.getOAuthCredentialRef().get().getExpiresIn() * this.updateThresholdRatio);
                this.tokenRefresher.schedule(this::refreshToken, nextRefreshDelay, TimeUnit.SECONDS);
                LOGGER.debug("Refresh access token, next refresh is scheduled after {} seconds", (Object)nextRefreshDelay);
                return;
            }
            catch (IOException e) {
                break;
            }
            catch (SFException e1) {
                try {
                    Thread.sleep((1L << retries) * 1000L);
                    continue;
                }
                catch (InterruptedException e2) {
                    throw new SFException(ErrorCode.OAUTH_REFRESH_TOKEN_ERROR, e2.getMessage());
                }
            }
        }
        this.refreshFailed.set(true);
        throw new SecurityException("Fail to refresh access token");
    }

    @Override
    public void close() {
        this.tokenRefresher.shutdown();
    }
}

