/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming;

import java.util.Map;
import java.util.Properties;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestClient;
import net.snowflake.ingest.streaming.internal.SnowflakeStreamingIngestClientInternal;
import net.snowflake.ingest.utils.SnowflakeURL;
import net.snowflake.ingest.utils.Utils;

public class SnowflakeStreamingIngestClientFactory {
    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private Properties prop;
        private Map<String, Object> parameterOverrides;
        private boolean isTestMode;
        private boolean isIceberg;

        private Builder(String name) {
            this.name = name;
        }

        public Builder setProperties(Properties prop) {
            this.prop = prop;
            return this;
        }

        public Builder setParameterOverrides(Map<String, Object> parameterOverrides) {
            this.parameterOverrides = parameterOverrides;
            return this;
        }

        public Builder setIsTestMode(boolean isTestMode) {
            this.isTestMode = isTestMode;
            return this;
        }

        Builder setIsIceberg(boolean isIceberg) {
            this.isIceberg = isIceberg;
            return this;
        }

        public SnowflakeStreamingIngestClient build() {
            Utils.assertStringNotNullOrEmpty("client name", this.name);
            Utils.assertNotNull("connection properties", this.prop);
            Properties prop = Utils.createProperties(this.prop);
            SnowflakeURL accountURL = new SnowflakeURL(prop.getProperty("url"));
            return new SnowflakeStreamingIngestClientInternal(this.name, accountURL, prop, this.parameterOverrides, this.isIceberg, this.isTestMode);
        }
    }
}

