/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.util.concurrent.atomic.AtomicLong;

class ChannelRuntimeState {
    private volatile boolean isValid;
    private volatile String startOffsetToken;
    private volatile String endOffsetToken;
    private final AtomicLong rowSequencer;
    private Long firstInsertInMs;
    private Long lastInsertInMs;

    ChannelRuntimeState(String endOffsetToken, long rowSequencer, boolean isValid) {
        this.endOffsetToken = endOffsetToken;
        this.rowSequencer = new AtomicLong(rowSequencer);
        this.isValid = isValid;
    }

    boolean isValid() {
        return this.isValid;
    }

    void invalidate() {
        this.isValid = false;
    }

    String getEndOffsetToken() {
        return this.endOffsetToken;
    }

    String getStartOffsetToken() {
        return this.startOffsetToken;
    }

    long incrementAndGetRowSequencer() {
        return this.rowSequencer.incrementAndGet();
    }

    long getRowSequencer() {
        return this.rowSequencer.get();
    }

    void updateOffsetToken(String startOffsetToken, String endOffsetToken, int rowCount) {
        if (rowCount == 0) {
            this.startOffsetToken = startOffsetToken;
        }
        this.endOffsetToken = endOffsetToken;
    }

    void updateInsertStats(long currentTimeInMs, int rowCount) {
        if (rowCount == 0) {
            this.firstInsertInMs = currentTimeInMs;
        }
        this.lastInsertInMs = currentTimeInMs;
    }

    Long getFirstInsertInMs() {
        return this.firstInsertInMs;
    }

    Long getLastInsertInMs() {
        return this.lastInsertInMs;
    }
}

