/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.util.Optional;
import net.snowflake.ingest.streaming.internal.InternalParameterProvider;
import net.snowflake.ingest.streaming.internal.SnowflakeStreamingIngestClientInternal;
import net.snowflake.ingest.utils.Constants;
import net.snowflake.ingest.utils.ParameterProvider;

public class ClientBufferParameters {
    private static final String BDEC_PARQUET_MESSAGE_TYPE_NAME = "bdec";
    private static final String PARQUET_MESSAGE_TYPE_NAME = "schema";
    private long maxChunkSizeInBytes;
    private long maxAllowedRowSizeInBytes;
    private final boolean enableNewJsonParsingLogic;
    private Constants.BdecParquetCompression bdecParquetCompression;
    private final Optional<Integer> maxRowGroups;
    private boolean isIcebergMode;

    private ClientBufferParameters(long maxChunkSizeInBytes, long maxAllowedRowSizeInBytes, Constants.BdecParquetCompression bdecParquetCompression, boolean enableNewJsonParsingLogic, Optional<Integer> maxRowGroups, boolean isIcebergMode) {
        this.maxChunkSizeInBytes = maxChunkSizeInBytes;
        this.maxAllowedRowSizeInBytes = maxAllowedRowSizeInBytes;
        this.bdecParquetCompression = bdecParquetCompression;
        this.enableNewJsonParsingLogic = enableNewJsonParsingLogic;
        this.maxRowGroups = maxRowGroups;
        this.isIcebergMode = isIcebergMode;
    }

    public ClientBufferParameters(SnowflakeStreamingIngestClientInternal clientInternal) {
        this.maxChunkSizeInBytes = clientInternal != null ? clientInternal.getParameterProvider().getMaxChunkSizeInBytes() : 0x10000000L;
        this.maxAllowedRowSizeInBytes = clientInternal != null ? clientInternal.getParameterProvider().getMaxAllowedRowSizeInBytes() : 0x4000000L;
        this.bdecParquetCompression = clientInternal != null ? clientInternal.getParameterProvider().getBdecParquetCompressionAlgorithm() : ParameterProvider.BDEC_PARQUET_COMPRESSION_ALGORITHM_DEFAULT;
        this.enableNewJsonParsingLogic = clientInternal != null ? clientInternal.getParameterProvider().isEnableNewJsonParsingLogic() : true;
        this.isIcebergMode = clientInternal != null ? clientInternal.isIcebergMode() : false;
        this.maxRowGroups = this.isIcebergMode ? Optional.of(InternalParameterProvider.MAX_ROW_GROUP_COUNT_ICEBERG_MODE_DEFAULT) : Optional.empty();
    }

    public static ClientBufferParameters test_createClientBufferParameters(long maxChunkSizeInBytes, long maxAllowedRowSizeInBytes, Constants.BdecParquetCompression bdecParquetCompression, boolean enableNewJsonParsingLogic, Optional<Integer> maxRowGroups, boolean isIcebergMode) {
        return new ClientBufferParameters(maxChunkSizeInBytes, maxAllowedRowSizeInBytes, bdecParquetCompression, enableNewJsonParsingLogic, maxRowGroups, isIcebergMode);
    }

    public long getMaxChunkSizeInBytes() {
        return this.maxChunkSizeInBytes;
    }

    public long getMaxAllowedRowSizeInBytes() {
        return this.maxAllowedRowSizeInBytes;
    }

    public Constants.BdecParquetCompression getBdecParquetCompression() {
        return this.bdecParquetCompression;
    }

    public boolean isEnableNewJsonParsingLogic() {
        return this.enableNewJsonParsingLogic;
    }

    public boolean getIsIcebergMode() {
        return this.isIcebergMode;
    }

    public Optional<Integer> getMaxRowGroups() {
        return this.maxRowGroups;
    }

    public String getParquetMessageTypeName() {
        return this.isIcebergMode ? PARQUET_MESSAGE_TYPE_NAME : BDEC_PARQUET_MESSAGE_TYPE_NAME;
    }
}

