/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.snowflake.ingest.streaming.internal.IStreamingIngestRequest;
import net.snowflake.ingest.utils.Utils;

class DropChannelRequestInternal
implements IStreamingIngestRequest {
    @JsonProperty(value="request_id")
    private String requestId;
    @JsonProperty(value="role")
    private String role;
    @JsonProperty(value="channel")
    private String channel;
    @JsonProperty(value="table")
    private String table;
    @JsonProperty(value="database")
    private String database;
    @JsonProperty(value="schema")
    private String schema;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="client_sequencer")
    Long clientSequencer;
    @JsonProperty(value="is_iceberg")
    boolean isIceberg;

    DropChannelRequestInternal(String requestId, String role, String database, String schema, String table, String channel, boolean isIceberg, Long clientSequencer) {
        this.requestId = requestId;
        this.role = role;
        this.database = database;
        this.schema = schema;
        this.table = table;
        this.channel = channel;
        this.isIceberg = isIceberg;
        this.clientSequencer = clientSequencer;
    }

    String getRequestId() {
        return this.requestId;
    }

    String getRole() {
        return this.role;
    }

    String getChannel() {
        return this.channel;
    }

    String getTable() {
        return this.table;
    }

    String getDatabase() {
        return this.database;
    }

    String getSchema() {
        return this.schema;
    }

    boolean isIceberg() {
        return this.isIceberg;
    }

    Long getClientSequencer() {
        return this.clientSequencer;
    }

    String getFullyQualifiedTableName() {
        return Utils.getFullyQualifiedTableName(this.database, this.schema, this.table);
    }

    @Override
    public String getStringForLogging() {
        return String.format("DropChannelRequest(requestId=%s, role=%s, db=%s, schema=%s, table=%s, channel=%s, isIceberg=%s, clientSequencer=%s)", this.requestId, this.role, this.database, this.schema, this.table, this.channel, this.isIceberg, this.clientSequencer);
    }
}

