/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.snowflake.ingest.connection.IngestResponseException;
import net.snowflake.ingest.streaming.internal.BlobPath;
import net.snowflake.ingest.streaming.internal.ClientConfigureRequest;
import net.snowflake.ingest.streaming.internal.ClientConfigureResponse;
import net.snowflake.ingest.streaming.internal.ExternalVolume;
import net.snowflake.ingest.streaming.internal.FileLocationInfo;
import net.snowflake.ingest.streaming.internal.GeneratePresignedUrlsResponse;
import net.snowflake.ingest.streaming.internal.IStorageManager;
import net.snowflake.ingest.streaming.internal.SnowflakeServiceClient;
import net.snowflake.ingest.streaming.internal.TableRef;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.Logging;
import net.snowflake.ingest.utils.SFException;

class ExternalVolumeManager
implements IStorageManager {
    private static final Logging logger = new Logging(ExternalVolumeManager.class);
    private final Map<String, ExternalVolume> externalVolumeMap;
    private final String clientName;
    private final String role;
    private final SnowflakeServiceClient serviceClient;
    private final String clientPrefix;
    private final Long deploymentId;
    private final Object registerTableLock = new Object();

    ExternalVolumeManager(boolean isTestMode, String role, String clientName, SnowflakeServiceClient snowflakeServiceClient) {
        this.clientName = clientName;
        this.role = role;
        this.serviceClient = snowflakeServiceClient;
        this.externalVolumeMap = new ConcurrentHashMap<String, ExternalVolume>();
        try {
            ClientConfigureResponse response = this.serviceClient.clientConfigure(new ClientConfigureRequest(role));
            this.clientPrefix = isTestMode ? "testPrefix" : response.getClientPrefix();
            this.deploymentId = response.getDeploymentId();
        }
        catch (IOException | IngestResponseException e) {
            throw new SFException(e, ErrorCode.CLIENT_CONFIGURE_FAILURE, e.getMessage());
        }
        logger.logDebug("Created ExternalVolumeManager with clientName=%s and clientPrefix=%s", clientName, this.clientPrefix);
    }

    @Override
    public ExternalVolume getStorage(String fullyQualifiedTableName) {
        return this.getVolumeSafe(fullyQualifiedTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTable(TableRef tableRef, FileLocationInfo locationInfo) {
        if (this.externalVolumeMap.containsKey(tableRef.fullyQualifiedName)) {
            logger.logInfo("Skip registering table since its already been registered with the VolumeManager. tableRef=%s", tableRef);
            return;
        }
        Object object = this.registerTableLock;
        synchronized (object) {
            if (this.externalVolumeMap.containsKey(tableRef.fullyQualifiedName)) {
                logger.logInfo("Skip registering table since its already been registered with the VolumeManager. tableRef=%s", tableRef);
                return;
            }
            try {
                ExternalVolume externalVolume = new ExternalVolume(this.clientName, this.getClientPrefix(), this.deploymentId, this.role, tableRef, locationInfo, this.serviceClient);
                this.externalVolumeMap.put(tableRef.fullyQualifiedName, externalVolume);
            }
            catch (SFException ex) {
                logger.logError("ExtVolManager.registerTable for tableRef=% failed with exception=%s", tableRef, ex);
                throw ex;
            }
            catch (Exception err) {
                logger.logError("ExtVolManager.registerTable for tableRef=% failed with exception=%s", tableRef, err);
                throw new SFException(err, ErrorCode.UNABLE_TO_CONNECT_TO_STAGE, String.format("fullyQualifiedTableName=%s", tableRef));
            }
        }
    }

    @Override
    public BlobPath generateBlobPath(String fullyQualifiedTableName) {
        ExternalVolume volume = this.getVolumeSafe(fullyQualifiedTableName);
        GeneratePresignedUrlsResponse.PresignedUrlInfo urlInfo = volume.dequeueUrlInfo();
        return BlobPath.presignedUrlWithToken(urlInfo.fileName, urlInfo.url);
    }

    @Override
    public String getClientPrefix() {
        return this.clientPrefix;
    }

    private ExternalVolume getVolumeSafe(String fullyQualifiedTableName) {
        ExternalVolume volume = this.externalVolumeMap.get(fullyQualifiedTableName);
        if (volume == null) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, String.format("No external volume found for tableRef=%s", fullyQualifiedTableName));
        }
        return volume;
    }
}

