/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferConfig;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadata;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.internal.apache.commons.io.FileUtils;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.ingest.streaming.internal.BlobPath;
import net.snowflake.ingest.streaming.internal.FileLocationInfo;
import net.snowflake.ingest.streaming.internal.IStorage;
import net.snowflake.ingest.streaming.internal.InternalStageManager;
import net.snowflake.ingest.streaming.internal.SnowflakeFileTransferMetadataWithAge;
import net.snowflake.ingest.streaming.internal.StreamingIngestUtils;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.HttpUtil;
import net.snowflake.ingest.utils.Logging;
import net.snowflake.ingest.utils.SFException;
import net.snowflake.ingest.utils.Utils;

class InternalStage<T>
implements IStorage {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper parseConfigureResponseMapper = new net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper();
    private static final long REFRESH_THRESHOLD_IN_MS = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);
    private static final Duration refreshDuration = Duration.ofMinutes(58L);
    private static Instant prevRefresh = Instant.EPOCH;
    private static final Logging logger = new Logging(InternalStage.class);
    private SnowflakeFileTransferMetadataWithAge fileTransferMetadataWithAge;
    private final InternalStageManager<T> owningManager;
    private final String clientName;
    private final int maxUploadRetries;
    private final Properties proxyProperties;

    InternalStage(InternalStageManager<T> owningManager, String clientName, FileLocationInfo fileLocationInfo, int maxUploadRetries) throws SnowflakeSQLException, IOException {
        this(owningManager, clientName, (SnowflakeFileTransferMetadataWithAge)null, maxUploadRetries);
        Utils.assertStringNotNullOrEmpty("client prefix", this.owningManager.getClientPrefix());
        this.fileTransferMetadataWithAge = InternalStage.createFileTransferMetadataWithAge(fileLocationInfo);
    }

    InternalStage(InternalStageManager<T> owningManager, String clientName, SnowflakeFileTransferMetadataWithAge testMetadata, int maxUploadRetries) throws SnowflakeSQLException, IOException {
        this.owningManager = owningManager;
        this.clientName = clientName;
        this.maxUploadRetries = maxUploadRetries;
        this.proxyProperties = HttpUtil.generateProxyPropertiesForJDBC();
        this.fileTransferMetadataWithAge = testMetadata;
    }

    private void putRemote(String fullFilePath, byte[] data, int retryCount) throws SnowflakeSQLException, IOException {
        SnowflakeFileTransferMetadataV1 fileTransferMetadataCopy;
        if (this.fileTransferMetadataWithAge.fileTransferMetadata.isForOneFile()) {
            fileTransferMetadataCopy = this.fetchSignedURL(fullFilePath);
        } else {
            SnowflakeFileTransferMetadataV1 fileTransferMetadata = this.fileTransferMetadataWithAge.fileTransferMetadata;
            fileTransferMetadataCopy = new SnowflakeFileTransferMetadataV1(fileTransferMetadata.getPresignedUrl(), fullFilePath, fileTransferMetadata.getEncryptionMaterial() != null ? fileTransferMetadata.getEncryptionMaterial().getQueryStageMasterKey() : null, fileTransferMetadata.getEncryptionMaterial() != null ? fileTransferMetadata.getEncryptionMaterial().getQueryId() : null, fileTransferMetadata.getEncryptionMaterial() != null ? fileTransferMetadata.getEncryptionMaterial().getSmkId() : null, fileTransferMetadata.getCommandType(), fileTransferMetadata.getStageInfo());
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        try {
            if (Instant.now().isAfter(prevRefresh.plus(refreshDuration))) {
                this.refreshSnowflakeMetadata(false);
            }
            SnowflakeFileTransferAgent.uploadWithoutConnection((SnowflakeFileTransferConfig)SnowflakeFileTransferConfig.Builder.newInstance().setSnowflakeFileTransferMetadata((SnowflakeFileTransferMetadata)fileTransferMetadataCopy).setUploadStream((InputStream)inStream).setRequireCompress(false).setOcspMode(OCSPMode.FAIL_OPEN).setStreamingIngestClientKey(this.owningManager.getClientPrefix()).setStreamingIngestClientName(this.clientName).setProxyProperties(this.proxyProperties).setDestFileName(fullFilePath).build());
        }
        catch (Exception e) {
            if (retryCount == 0) {
                this.refreshSnowflakeMetadata(false);
            }
            if (retryCount >= this.maxUploadRetries) {
                logger.logError("Failed to upload to stage, retry attempts exhausted ({}), client={}, message={}", this.maxUploadRetries, this.clientName, e.getMessage());
                throw new SFException(e, ErrorCode.IO_ERROR, new Object[0]);
            }
            StreamingIngestUtils.sleepForRetry(++retryCount);
            logger.logInfo("Retrying upload, attempt {}/{} msg: {}, stackTrace:{}", retryCount, this.maxUploadRetries, e.getMessage(), Utils.getStackTrace(e));
            this.putRemote(fullFilePath, data, retryCount);
        }
    }

    synchronized SnowflakeFileTransferMetadataWithAge refreshSnowflakeMetadata(boolean force) throws SnowflakeSQLException, IOException {
        SnowflakeFileTransferMetadataWithAge metadata;
        logger.logInfo("Refresh Snowflake metadata, client={} force={}", this.clientName, force);
        if (!force && this.fileTransferMetadataWithAge != null && this.fileTransferMetadataWithAge.timestamp.isPresent() && this.fileTransferMetadataWithAge.timestamp.get() > System.currentTimeMillis() - REFRESH_THRESHOLD_IN_MS) {
            return this.fileTransferMetadataWithAge;
        }
        FileLocationInfo location = this.owningManager.getRefreshedLocation(Optional.empty());
        this.fileTransferMetadataWithAge = metadata = InternalStage.createFileTransferMetadataWithAge(location);
        return metadata;
    }

    static SnowflakeFileTransferMetadataWithAge createFileTransferMetadataWithAge(FileLocationInfo fileLocationInfo) throws JsonProcessingException, net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException, SnowflakeSQLException {
        SnowflakeFileTransferMetadataWithAge fileTransferMetadataWithAge = fileLocationInfo.getLocationType().replaceAll("^[\"]|[\"]$", "").equals(StageInfo.StageType.LOCAL_FS.name()) ? new SnowflakeFileTransferMetadataWithAge(fileLocationInfo.getLocation().replaceAll("^[\"]|[\"]$", ""), Optional.of(System.currentTimeMillis())) : new SnowflakeFileTransferMetadataWithAge((SnowflakeFileTransferMetadataV1)SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)InternalStage.parseFileLocationInfo(fileLocationInfo)).get(0), Optional.of(System.currentTimeMillis()));
        prevRefresh = Instant.now();
        return fileTransferMetadataWithAge;
    }

    SnowflakeFileTransferMetadataV1 fetchSignedURL(String fileName) throws SnowflakeSQLException, IOException {
        FileLocationInfo location = this.owningManager.getRefreshedLocation(Optional.of(fileName));
        SnowflakeFileTransferMetadataV1 metadata = (SnowflakeFileTransferMetadataV1)SnowflakeFileTransferAgent.getFileTransferMetadatas((JsonNode)InternalStage.parseFileLocationInfo(location)).get(0);
        metadata.setPresignedUrlFileName(fileName);
        return metadata;
    }

    static JsonNode parseFileLocationInfo(FileLocationInfo fileLocationInfo) throws JsonProcessingException, net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException {
        com.fasterxml.jackson.databind.JsonNode fileLocationInfoNode = mapper.valueToTree((Object)fileLocationInfo);
        ObjectNode node = mapper.createObjectNode();
        node.putObject("data");
        ObjectNode dataNode = (ObjectNode)node.get("data");
        dataNode.set("stageInfo", fileLocationInfoNode);
        dataNode.putArray("src_locations").add("placeholder");
        String responseString = mapper.writeValueAsString((Object)node);
        return parseConfigureResponseMapper.readTree(responseString);
    }

    @Override
    public void put(BlobPath blobPath, byte[] blob) {
        String filePath = blobPath.fileName;
        if (this.isLocalFS()) {
            InternalStage.putLocal(this.fileTransferMetadataWithAge.localLocation, filePath, blob);
        } else {
            try {
                this.putRemote(filePath, blob, 0);
            }
            catch (IOException | SnowflakeSQLException e) {
                throw new SFException(e, ErrorCode.BLOB_UPLOAD_FAILURE, new Object[0]);
            }
        }
    }

    boolean isLocalFS() {
        return this.fileTransferMetadataWithAge.isLocalFS;
    }

    @VisibleForTesting
    static void putLocal(String stageLocation, String fullFilePath, byte[] data) {
        if (fullFilePath == null || fullFilePath.isEmpty() || fullFilePath.endsWith("/")) {
            throw new SFException(ErrorCode.BLOB_UPLOAD_FAILURE, new Object[0]);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        try {
            File destFile = Paths.get(stageLocation, fullFilePath).toFile();
            FileUtils.copyInputStreamToFile((InputStream)input, (File)destFile);
        }
        catch (Exception ex) {
            throw new SFException(ex, ErrorCode.BLOB_UPLOAD_FAILURE, new Object[0]);
        }
    }
}

