/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Calendar;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.ingest.connection.IngestResponseException;
import net.snowflake.ingest.streaming.internal.BlobPath;
import net.snowflake.ingest.streaming.internal.ClientConfigureRequest;
import net.snowflake.ingest.streaming.internal.ClientConfigureResponse;
import net.snowflake.ingest.streaming.internal.FileLocationInfo;
import net.snowflake.ingest.streaming.internal.IStorageManager;
import net.snowflake.ingest.streaming.internal.InternalStage;
import net.snowflake.ingest.streaming.internal.SnowflakeFileTransferMetadataWithAge;
import net.snowflake.ingest.streaming.internal.SnowflakeServiceClient;
import net.snowflake.ingest.streaming.internal.TableRef;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;
import net.snowflake.ingest.utils.Utils;

class InternalStageManager<T>
implements IStorageManager {
    private final InternalStage<T> targetStage;
    private final AtomicLong counter;
    private final boolean isTestMode;
    private final SnowflakeServiceClient snowflakeServiceClient;
    private final String clientName;
    private final String role;
    private String clientPrefix;
    private Long deploymentId;

    InternalStageManager(boolean isTestMode, String role, String clientName, SnowflakeServiceClient snowflakeServiceClient) {
        this.snowflakeServiceClient = snowflakeServiceClient;
        this.isTestMode = isTestMode;
        this.clientName = clientName;
        this.role = role;
        this.counter = new AtomicLong(0L);
        try {
            if (!isTestMode) {
                ClientConfigureResponse response = this.snowflakeServiceClient.clientConfigure(new ClientConfigureRequest(role));
                this.clientPrefix = response.getClientPrefix();
                this.deploymentId = response.getDeploymentId();
                this.targetStage = new InternalStage(this, clientName, response.getStageLocation(), 5);
            } else {
                this.clientPrefix = null;
                this.deploymentId = null;
                this.targetStage = new InternalStage(this, "testClient", (SnowflakeFileTransferMetadataWithAge)null, 5);
            }
        }
        catch (IOException | IngestResponseException e) {
            throw new SFException(e, ErrorCode.CLIENT_CONFIGURE_FAILURE, e.getMessage());
        }
        catch (SnowflakeSQLException e) {
            throw new SFException(e, ErrorCode.UNABLE_TO_CONNECT_TO_STAGE, e.getMessage());
        }
    }

    @Override
    public InternalStage<T> getStorage(String fullyQualifiedTableName) {
        return this.targetStage;
    }

    @Override
    public void registerTable(TableRef tableRef, FileLocationInfo locationInfo) {
    }

    FileLocationInfo getRefreshedLocation(Optional<String> fileName) {
        try {
            ClientConfigureRequest request = new ClientConfigureRequest(this.role);
            fileName.ifPresent(request::setFileName);
            ClientConfigureResponse response = this.snowflakeServiceClient.clientConfigure(request);
            if (this.clientPrefix == null) {
                this.clientPrefix = response.getClientPrefix();
                this.deploymentId = response.getDeploymentId();
            }
            if (this.deploymentId != null && !this.deploymentId.equals(response.getDeploymentId())) {
                throw new SFException(ErrorCode.CLIENT_DEPLOYMENT_ID_MISMATCH, this.deploymentId, response.getDeploymentId(), this.clientName);
            }
            return response.getStageLocation();
        }
        catch (IOException | IngestResponseException e) {
            throw new SFException(e, ErrorCode.CLIENT_CONFIGURE_FAILURE, e.getMessage());
        }
    }

    @Override
    public BlobPath generateBlobPath(String fullyQualifiedTableName) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        return BlobPath.fileNameWithoutToken(this.getNextFileName(calendar, this.clientPrefix));
    }

    @VisibleForTesting
    public String getNextFileName(Calendar calendar, String clientPrefix) {
        if (this.isTestMode && clientPrefix == null) {
            clientPrefix = "testPrefix";
        }
        Utils.assertStringNotNullOrEmpty("client prefix", clientPrefix);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        long time = TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis());
        long threadId = Thread.currentThread().getId();
        String blobShortName = Long.toString(time, 36) + "_" + clientPrefix + "_" + threadId + "_" + this.counter.getAndIncrement() + "." + "bdec";
        return year + "/" + month + "/" + day + "/" + hour + "/" + minute + "/" + blobShortName;
    }

    @Override
    public String getClientPrefix() {
        return this.clientPrefix;
    }
}

