/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.snowflake.ingest.streaming.internal.MemoryInfoProvider;

public class MemoryInfoProviderFromRuntime
implements MemoryInfoProvider {
    private final long maxMemory = Runtime.getRuntime().maxMemory();
    private volatile long totalFreeMemory = Runtime.getRuntime().freeMemory() + (this.maxMemory - Runtime.getRuntime().totalMemory());
    private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, r -> {
        Thread th = new Thread(r, "MemoryInfoProviderFromRuntime");
        th.setDaemon(true);
        return th;
    });
    private static final long FREE_MEMORY_UPDATE_INTERVAL_MS = 100L;
    private static final MemoryInfoProviderFromRuntime INSTANCE = new MemoryInfoProviderFromRuntime(100L);

    private MemoryInfoProviderFromRuntime(long freeMemoryUpdateIntervalMs) {
        this.executorService.scheduleAtFixedRate(this::updateFreeMemory, 0L, freeMemoryUpdateIntervalMs, TimeUnit.MILLISECONDS);
    }

    private void updateFreeMemory() {
        this.totalFreeMemory = Runtime.getRuntime().freeMemory() + (this.maxMemory - Runtime.getRuntime().totalMemory());
    }

    public static MemoryInfoProviderFromRuntime getInstance() {
        return INSTANCE;
    }

    @Override
    public long getMaxMemory() {
        return this.maxMemory;
    }

    @Override
    public long getFreeMemory() {
        return this.totalFreeMemory;
    }
}

