/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.snowflake.client.jdbc.internal.google.common.collect.Sets;
import net.snowflake.ingest.connection.TelemetryService;
import net.snowflake.ingest.streaming.OffsetTokenVerificationFunction;
import net.snowflake.ingest.streaming.OpenChannelRequest;
import net.snowflake.ingest.streaming.internal.AbstractRowBuffer;
import net.snowflake.ingest.streaming.internal.ChannelRuntimeState;
import net.snowflake.ingest.streaming.internal.ClientBufferParameters;
import net.snowflake.ingest.streaming.internal.ColumnMetadata;
import net.snowflake.ingest.streaming.internal.Flusher;
import net.snowflake.ingest.streaming.internal.IcebergParquetValueParser;
import net.snowflake.ingest.streaming.internal.LiteralQuoteUtils;
import net.snowflake.ingest.streaming.internal.ParquetBufferValue;
import net.snowflake.ingest.streaming.internal.ParquetChunkData;
import net.snowflake.ingest.streaming.internal.ParquetColumn;
import net.snowflake.ingest.streaming.internal.ParquetFlusher;
import net.snowflake.ingest.streaming.internal.ParquetTypeGenerator;
import net.snowflake.ingest.streaming.internal.ParquetTypeInfo;
import net.snowflake.ingest.streaming.internal.RowBufferStats;
import net.snowflake.ingest.streaming.internal.SnowflakeParquetValueParser;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;
import net.snowflake.ingest.utils.Utils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetRowBuffer
extends AbstractRowBuffer<ParquetChunkData> {
    private final Map<String, ParquetColumn> fieldIndex = new HashMap<String, ParquetColumn>();
    private final Map<String, String> metadata = new HashMap<String, String>();
    private final List<List<Object>> data = new ArrayList<List<Object>>();
    private final List<List<Object>> tempData = new ArrayList<List<Object>>();
    private MessageType schema;

    ParquetRowBuffer(OpenChannelRequest.OnErrorOption onErrorOption, ZoneId defaultTimezone, String fullyQualifiedChannelName, Consumer<Float> rowSizeMetric, ChannelRuntimeState channelRuntimeState, ClientBufferParameters clientBufferParameters, OffsetTokenVerificationFunction offsetTokenVerificationFunction, TelemetryService telemetryService) {
        super(onErrorOption, defaultTimezone, fullyQualifiedChannelName, rowSizeMetric, channelRuntimeState, clientBufferParameters, offsetTokenVerificationFunction, telemetryService);
    }

    @Override
    public void setupSchema(List<ColumnMetadata> columns) {
        this.fieldIndex.clear();
        this.metadata.clear();
        this.metadata.put("sfVer", "1,1");
        ArrayList<Type> parquetTypes = new ArrayList<Type>();
        int id = 1;
        for (ColumnMetadata column : columns) {
            this.validateColumnCollation(column);
            ParquetTypeInfo typeInfo = ParquetTypeGenerator.generateColumnParquetTypeInfo(column, id);
            Type parquetType = typeInfo.getParquetType();
            parquetTypes.add(parquetType);
            this.metadata.putAll(typeInfo.getMetadata());
            int columnIndex = parquetTypes.size() - 1;
            this.fieldIndex.put(column.getInternalName(), new ParquetColumn(column, columnIndex, parquetType));
            if (!column.getNullable()) {
                this.addNonNullableFieldName(column.getInternalName());
            }
            if (!this.clientBufferParameters.getIsIcebergMode()) {
                this.statsMap.put(column.getInternalName(), new RowBufferStats(column.getName(), column.getCollation(), column.getOrdinal(), null, parquetType.isPrimitive() ? parquetType.asPrimitiveType() : null));
                if (this.onErrorOption == OpenChannelRequest.OnErrorOption.ABORT || this.onErrorOption == OpenChannelRequest.OnErrorOption.SKIP_BATCH) {
                    this.tempStatsMap.put(column.getInternalName(), new RowBufferStats(column.getName(), column.getCollation(), column.getOrdinal(), null, parquetType.isPrimitive() ? parquetType.asPrimitiveType() : null));
                }
            }
            ++id;
        }
        this.schema = new MessageType(this.clientBufferParameters.getParquetMessageTypeName(), parquetTypes);
        if (this.clientBufferParameters.getIsIcebergMode()) {
            for (ColumnDescriptor columnDescriptor : this.schema.getColumns()) {
                String columnPath = Utils.concatDotPath(columnDescriptor.getPath());
                PrimitiveType primitiveType = columnDescriptor.getPrimitiveType();
                int fieldId = columnDescriptor.getPath().length == 1 ? 0 : primitiveType.getId().intValue();
                int ordinal = this.schema.getType(columnDescriptor.getPath()[0]).getId().intValue();
                this.statsMap.put(columnPath, new RowBufferStats(columnPath, null, ordinal, fieldId, primitiveType));
                if (this.onErrorOption != OpenChannelRequest.OnErrorOption.ABORT && this.onErrorOption != OpenChannelRequest.OnErrorOption.SKIP_BATCH) continue;
                this.tempStatsMap.put(columnPath, new RowBufferStats(columnPath, null, ordinal, fieldId, primitiveType));
            }
        }
        this.tempData.clear();
        this.data.clear();
    }

    @Override
    boolean hasColumn(String name) {
        return this.fieldIndex.containsKey(name);
    }

    @Override
    float addRow(Map<String, Object> row, int bufferedRowIndex, Map<String, RowBufferStats> statsMap, Set<String> formattedInputColumnNames, long insertRowIndex) {
        return this.addRow(row, this::writeRow, statsMap, formattedInputColumnNames, insertRowIndex);
    }

    void writeRow(List<Object> row) {
        this.data.add(row);
    }

    @Override
    float addTempRow(Map<String, Object> row, int curRowIndex, Map<String, RowBufferStats> statsMap, Set<String> formattedInputColumnNames, long insertRowIndex) {
        return this.addRow(row, this.tempData::add, statsMap, formattedInputColumnNames, insertRowIndex);
    }

    private float addRow(Map<String, Object> row, Consumer<List<Object>> out, Map<String, RowBufferStats> statsMap, Set<String> inputColumnNames, long insertRowsCurrIndex) {
        String columnName2;
        Object[] indexedRow = new Object[this.fieldIndex.size()];
        float size = 0.0f;
        HashMap<String, RowBufferStats> forkedStatsMap = new HashMap<String, RowBufferStats>();
        statsMap.forEach((columnName, stats) -> forkedStatsMap.put((String)columnName, stats.forkEmpty()));
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            columnName2 = LiteralQuoteUtils.unquoteColumnName(key);
            ParquetColumn parquetColumn = this.fieldIndex.get(columnName2);
            int colIndex = parquetColumn.index;
            ColumnMetadata column = parquetColumn.columnMetadata;
            ParquetBufferValue valueWithSize = this.clientBufferParameters.getIsIcebergMode() ? IcebergParquetValueParser.parseColumnValueToParquet(value, parquetColumn.type, forkedStatsMap, this.defaultTimezone, insertRowsCurrIndex) : SnowflakeParquetValueParser.parseColumnValueToParquet(value, column, parquetColumn.type.asPrimitiveType().getPrimitiveTypeName(), (RowBufferStats)forkedStatsMap.get(columnName2), this.defaultTimezone, insertRowsCurrIndex, this.clientBufferParameters.isEnableNewJsonParsingLogic());
            indexedRow[colIndex] = valueWithSize.getValue();
            size += valueWithSize.getSize();
        }
        long rowSizeRoundedUp = Double.valueOf(Math.ceil(size)).longValue();
        if (rowSizeRoundedUp > this.clientBufferParameters.getMaxAllowedRowSizeInBytes()) {
            throw new SFException(ErrorCode.MAX_ROW_SIZE_EXCEEDED, String.format("rowSizeInBytes:%.3f, maxAllowedRowSizeInBytes:%d, rowIndex:%d", Float.valueOf(size), this.clientBufferParameters.getMaxAllowedRowSizeInBytes(), insertRowsCurrIndex));
        }
        out.accept(Arrays.asList(indexedRow));
        for (Map.Entry forkedColStats : forkedStatsMap.entrySet()) {
            columnName2 = (String)forkedColStats.getKey();
            statsMap.put(columnName2, RowBufferStats.getCombinedStats(statsMap.get(columnName2), (RowBufferStats)forkedColStats.getValue()));
        }
        for (String columnName3 : Sets.difference(this.fieldIndex.keySet(), inputColumnNames)) {
            statsMap.get(columnName3).incCurrentNullCount();
        }
        return size;
    }

    @Override
    void moveTempRowsToActualBuffer(int tempRowCount) {
        this.tempData.forEach(this::writeRow);
    }

    @Override
    void clearTempRows() {
        this.tempData.clear();
    }

    @Override
    boolean hasColumns() {
        return !this.fieldIndex.isEmpty();
    }

    @Override
    Optional<ParquetChunkData> getSnapshot() {
        ArrayList<List<Object>> oldData = new ArrayList<List<Object>>();
        this.data.forEach(r -> oldData.add(new ArrayList(r)));
        return this.bufferedRowCount <= 0 ? Optional.empty() : Optional.of(new ParquetChunkData(oldData, this.metadata));
    }

    @Override
    Object getVectorValueAt(String column, int index) {
        if (this.data == null) {
            return null;
        }
        int colIndex = this.fieldIndex.get((Object)column).index;
        Object value = this.data.get(index).get(colIndex);
        ColumnMetadata columnMetadata = this.fieldIndex.get((Object)column).columnMetadata;
        String physicalTypeStr = columnMetadata.getPhysicalType();
        AbstractRowBuffer.ColumnPhysicalType physicalType = AbstractRowBuffer.ColumnPhysicalType.valueOf(physicalTypeStr);
        String logicalTypeStr = columnMetadata.getLogicalType();
        AbstractRowBuffer.ColumnLogicalType logicalType = AbstractRowBuffer.ColumnLogicalType.valueOf(logicalTypeStr);
        if (logicalType == AbstractRowBuffer.ColumnLogicalType.FIXED) {
            if (physicalType == AbstractRowBuffer.ColumnPhysicalType.SB1) {
                value = ((Integer)value).byteValue();
            }
            if (physicalType == AbstractRowBuffer.ColumnPhysicalType.SB2) {
                value = ((Integer)value).shortValue();
            }
            if (physicalType == AbstractRowBuffer.ColumnPhysicalType.SB16) {
                value = new BigDecimal(new BigInteger((byte[])value), columnMetadata.getScale());
            }
        }
        if (logicalType == AbstractRowBuffer.ColumnLogicalType.BINARY && value != null) {
            Object object = value = value instanceof String ? (Object)((String)value).getBytes(StandardCharsets.UTF_8) : value;
        }
        if (Objects.equals(columnMetadata.getSourceIcebergDataType(), "\"string\"")) {
            value = value instanceof byte[] ? new String((byte[])value, StandardCharsets.UTF_8) : value;
        }
        return value;
    }

    @Override
    int getTempRowCount() {
        return this.tempData.size();
    }

    @Override
    void reset() {
        super.reset();
        this.data.clear();
    }

    @Override
    void closeInternal() {
    }

    @Override
    public Flusher<ParquetChunkData> createFlusher() {
        return new ParquetFlusher(this.schema, this.clientBufferParameters.getMaxChunkSizeInBytes(), this.clientBufferParameters.getMaxRowGroups(), this.clientBufferParameters.getBdecParquetCompression());
    }
}

