/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;
import net.snowflake.ingest.streaming.internal.BlobMetadata;
import net.snowflake.ingest.streaming.internal.IStreamingIngestRequest;

class RegisterBlobRequest
implements IStreamingIngestRequest {
    @JsonProperty(value="request_id")
    private String requestId;
    @JsonProperty(value="role")
    private String role;
    @JsonProperty(value="blobs")
    private List<BlobMetadata> blobs;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="is_iceberg")
    private boolean isIceberg;

    RegisterBlobRequest(String requestId, String role, List<BlobMetadata> blobs, boolean isIceberg) {
        this.requestId = requestId;
        this.role = role;
        this.blobs = blobs;
        this.isIceberg = isIceberg;
    }

    String getRequestId() {
        return this.requestId;
    }

    String getRole() {
        return this.role;
    }

    List<BlobMetadata> getBlobs() {
        return this.blobs;
    }

    boolean getIsIceberg() {
        return this.isIceberg;
    }

    @Override
    public String getStringForLogging() {
        return String.format("RegisterBlobRequest(requestId=%s, role=%s, blobs=[%s])", this.requestId, this.role, this.blobs.stream().map(BlobMetadata::getPath).collect(Collectors.joining(", ")));
    }
}

