/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.snowflake.ingest.streaming.internal.BlobMetadata;
import net.snowflake.ingest.streaming.internal.FlushService;
import net.snowflake.ingest.streaming.internal.SnowflakeStreamingIngestClientInternal;
import net.snowflake.ingest.utils.Logging;
import net.snowflake.ingest.utils.Pair;
import net.snowflake.ingest.utils.Utils;

class RegisterService<T> {
    private static final Logging logger = new Logging(RegisterService.class);
    private final SnowflakeStreamingIngestClientInternal<T> owningClient;
    private final List<Pair<FlushService.BlobData<T>, CompletableFuture<BlobMetadata>>> blobsList;
    private final Lock blobsListLock;
    private final boolean isTestMode;

    RegisterService(SnowflakeStreamingIngestClientInternal<T> client, boolean isTestMode) {
        this.owningClient = client;
        this.blobsList = new ArrayList<Pair<FlushService.BlobData<T>, CompletableFuture<BlobMetadata>>>();
        this.blobsListLock = new ReentrantLock();
        this.isTestMode = isTestMode;
    }

    void addBlobs(List<Pair<FlushService.BlobData<T>, CompletableFuture<BlobMetadata>>> blobs) {
        if (!blobs.isEmpty()) {
            this.blobsListLock.lock();
            try {
                this.blobsList.addAll(blobs);
            }
            finally {
                this.blobsListLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<FlushService.BlobData<T>> registerBlobs(Map<String, Timer.Context> latencyTimerContextMap) {
        ArrayList<FlushService.BlobData<T>> errorBlobs = new ArrayList<FlushService.BlobData<T>>();
        if (!this.blobsList.isEmpty() && this.blobsListLock.tryLock()) {
            ArrayList<Pair<FlushService.BlobData<T>, CompletableFuture<BlobMetadata>>> oldList = null;
            try {
                oldList = new ArrayList<Pair<FlushService.BlobData<T>, CompletableFuture<BlobMetadata>>>(this.blobsList);
                this.blobsList.clear();
            }
            finally {
                this.blobsListLock.unlock();
            }
            int idx = 0;
            int retry = 0;
            logger.logDebug("Start loop outer for uploading blobs={}", oldList.stream().map(blob -> ((FlushService.BlobData)blob.getKey()).getPath()).collect(Collectors.toList()));
            while (idx < oldList.size()) {
                ArrayList<BlobMetadata> blobs = new ArrayList<BlobMetadata>();
                long startTime = System.currentTimeMillis();
                logger.logDebug("Start loop inner for uploading blobs, size={}, idx={}", oldList.size(), idx);
                while (idx < oldList.size() && System.currentTimeMillis() - startTime <= TimeUnit.SECONDS.toMillis(10L)) {
                    Pair futureBlob = (Pair)oldList.get(idx);
                    try {
                        logger.logDebug("Start waiting on uploading blob={}, idx={}", ((FlushService.BlobData)futureBlob.getKey()).getPath(), idx);
                        BlobMetadata blob2 = (BlobMetadata)((CompletableFuture)futureBlob.getValue()).get(5L, TimeUnit.SECONDS);
                        logger.logDebug("Finish waiting on uploading blob={}, idx={}", ((FlushService.BlobData)futureBlob.getKey()).getPath(), idx);
                        if (blob2 != null) {
                            blobs.add(blob2);
                        }
                        retry = 0;
                        ++idx;
                    }
                    catch (Exception e) {
                        if (e instanceof TimeoutException && retry < this.owningClient.getParameterProvider().getBlobUploadMaxRetryCount()) {
                            logger.logInfo("Retry on waiting for uploading blob={}, idx={}", ((FlushService.BlobData)futureBlob.getKey()).getPath(), idx);
                            ++retry;
                            break;
                        }
                        String errorMessage = String.format("Building or uploading blob failed, client=%s, file=%s, exception=%s, detail=%s, cause=%s, cause_detail=%s, cause_trace=%s all channels in the blob will be invalidated", this.owningClient.getName(), ((FlushService.BlobData)futureBlob.getKey()).getPath(), e, e.getMessage(), e.getCause(), e.getCause() == null ? null : e.getCause().getMessage(), Utils.getStackTrace(e.getCause()));
                        logger.logError(errorMessage);
                        if (this.owningClient.getTelemetryService() != null) {
                            this.owningClient.getTelemetryService().reportClientFailure(this.getClass().getSimpleName(), errorMessage);
                        }
                        this.owningClient.getFlushService().invalidateAllChannelsInBlob(((FlushService.BlobData)futureBlob.getKey()).getData(), errorMessage);
                        errorBlobs.add((FlushService.BlobData)futureBlob.getKey());
                        retry = 0;
                        ++idx;
                    }
                }
                if (blobs.size() <= 0 || this.isTestMode) continue;
                logger.logInfo("Start registering blobs in client={}, totalBlobListSize={}, currentBlobListSize={}, idx={}", this.owningClient.getName(), oldList.size(), blobs.size(), idx);
                Timer.Context registerContext = Utils.createTimerContext(this.owningClient.registerLatency);
                this.owningClient.registerBlobs(blobs);
                if (registerContext == null) continue;
                registerContext.stop();
                blobs.forEach(blob -> latencyTimerContextMap.computeIfPresent(blob.getPath(), (k, v) -> {
                    v.stop();
                    return null;
                }));
            }
        }
        return errorBlobs;
    }

    List<Pair<FlushService.BlobData<T>, CompletableFuture<BlobMetadata>>> getBlobsList() {
        return this.blobsList;
    }
}

