/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.streaming.internal;

import javax.annotation.Nonnull;
import net.snowflake.ingest.utils.Utils;

class TableRef {
    final String dbName;
    final String schemaName;
    final String tableName;
    final String fullyQualifiedName;

    TableRef(@Nonnull String dbName, @Nonnull String schemaName, @Nonnull String tableName) {
        this.dbName = dbName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.fullyQualifiedName = Utils.getFullyQualifiedTableName(dbName, schemaName, tableName);
    }

    public int hashCode() {
        return this.dbName.hashCode() ^ this.schemaName.hashCode() ^ this.tableName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (TableRef.class != obj.getClass()) {
            return false;
        }
        TableRef other = (TableRef)obj;
        return this.dbName.equals(other.dbName) && this.schemaName.equals(other.schemaName) && this.tableName.equals(other.tableName);
    }

    public String toString() {
        return this.fullyQualifiedName;
    }
}

