/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.snowflake.ingest.utils.ErrorCode;
import net.snowflake.ingest.utils.SFException;
import org.apache.iceberg.parquet.TypeToMessageType;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.JsonUtil;
import org.apache.parquet.schema.Type;

public class IcebergDataTypeParser {
    private static final String TYPE = "type";
    private static final String STRUCT = "struct";
    private static final String LIST = "list";
    private static final String MAP = "map";
    private static final String FIELDS = "fields";
    private static final String ELEMENT = "element";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String DOC = "doc";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String ELEMENT_ID = "element-id";
    private static final String KEY_ID = "key-id";
    private static final String VALUE_ID = "value-id";
    private static final String REQUIRED = "required";
    private static final String ELEMENT_REQUIRED = "element-required";
    private static final String VALUE_REQUIRED = "value-required";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeToMessageType typeToMessageType = new TypeToMessageType();

    public static org.apache.parquet.schema.Type parseIcebergDataTypeStringToParquetType(String icebergDataType, Type.Repetition repetition, int id, String name) {
        Type icebergType = IcebergDataTypeParser.deserializeIcebergType(icebergDataType);
        if (icebergType.isPrimitiveType()) {
            return typeToMessageType.primitive(icebergType.asPrimitiveType(), repetition, id, name);
        }
        switch (icebergType.typeId()) {
            case LIST: {
                return typeToMessageType.list(icebergType.asListType(), repetition, id, name);
            }
            case MAP: {
                return typeToMessageType.map(icebergType.asMapType(), repetition, id, name);
            }
            case STRUCT: {
                return typeToMessageType.struct(icebergType.asStructType(), repetition, id, name);
            }
        }
        throw new SFException(ErrorCode.INTERNAL_ERROR, String.format("Cannot convert Iceberg column to parquet type, name=%s, dataType=%s", name, icebergDataType));
    }

    public static Type deserializeIcebergType(String icebergDataType) {
        try {
            JsonNode json = MAPPER.readTree(icebergDataType);
            return IcebergDataTypeParser.getTypeFromJson(json);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(String.format("Failed to deserialize Iceberg data type: %s", icebergDataType));
        }
    }

    public static Type getTypeFromJson(@Nonnull JsonNode jsonNode) {
        if (jsonNode.isTextual()) {
            return Types.fromPrimitiveString((String)jsonNode.asText());
        }
        if (jsonNode.isObject()) {
            if (!jsonNode.has(TYPE)) {
                throw new IllegalArgumentException(String.format("Missing key '%s' in schema: %s", TYPE, jsonNode));
            }
            String type = jsonNode.get(TYPE).asText();
            if (STRUCT.equals(type)) {
                return IcebergDataTypeParser.structFromJson(jsonNode);
            }
            if (LIST.equals(type)) {
                return IcebergDataTypeParser.listFromJson(jsonNode);
            }
            if (MAP.equals(type)) {
                return IcebergDataTypeParser.mapFromJson(jsonNode);
            }
            throw new IllegalArgumentException(String.format("Cannot parse Iceberg type: %s, schema: %s", type, jsonNode));
        }
        throw new IllegalArgumentException("Cannot parse Iceberg type from schema: " + jsonNode);
    }

    @Nonnull
    public static Types.StructType structFromJson(@Nonnull JsonNode json) {
        if (!json.has(FIELDS)) {
            throw new IllegalArgumentException(String.format("Missing key '%s' in schema: %s", FIELDS, json));
        }
        JsonNode fieldArray = json.get(FIELDS);
        Preconditions.checkArgument((fieldArray != null ? 1 : 0) != 0, (Object)"Field array cannot be null");
        Preconditions.checkArgument((boolean)fieldArray.isArray(), (String)"Cannot parse struct fields from non-array: %s", (Object)fieldArray);
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)fieldArray.size());
        Iterator iterator = fieldArray.elements();
        while (iterator.hasNext()) {
            JsonNode field = (JsonNode)iterator.next();
            Preconditions.checkArgument((boolean)field.isObject(), (String)"Cannot parse struct field from non-object: %s", (Object)field);
            int id = JsonUtil.getInt((String)ID, (JsonNode)field);
            String name = JsonUtil.getString((String)NAME, (JsonNode)field);
            Type type = IcebergDataTypeParser.getTypeFromJson(field.get(TYPE));
            String doc = JsonUtil.getStringOrNull((String)DOC, (JsonNode)field);
            boolean isRequired = JsonUtil.getBool((String)REQUIRED, (JsonNode)field);
            if (isRequired) {
                fields.add(Types.NestedField.required((int)id, (String)name, (Type)type, (String)doc));
                continue;
            }
            fields.add(Types.NestedField.optional((int)id, (String)name, (Type)type, (String)doc));
        }
        return Types.StructType.of((List)fields);
    }

    public static Types.ListType listFromJson(JsonNode json) {
        int elementId = JsonUtil.getInt((String)ELEMENT_ID, (JsonNode)json);
        Type elementType = IcebergDataTypeParser.getTypeFromJson(json.get(ELEMENT));
        boolean isRequired = JsonUtil.getBool((String)ELEMENT_REQUIRED, (JsonNode)json);
        if (isRequired) {
            return Types.ListType.ofRequired((int)elementId, (Type)elementType);
        }
        return Types.ListType.ofOptional((int)elementId, (Type)elementType);
    }

    public static Types.MapType mapFromJson(JsonNode json) {
        int keyId = JsonUtil.getInt((String)KEY_ID, (JsonNode)json);
        Type keyType = IcebergDataTypeParser.getTypeFromJson(json.get(KEY));
        int valueId = JsonUtil.getInt((String)VALUE_ID, (JsonNode)json);
        Type valueType = IcebergDataTypeParser.getTypeFromJson(json.get(VALUE));
        boolean isRequired = JsonUtil.getBool((String)VALUE_REQUIRED, (JsonNode)json);
        if (isRequired) {
            return Types.MapType.ofRequired((int)keyId, (int)valueId, (Type)keyType, (Type)valueType);
        }
        return Types.MapType.ofOptional((int)keyId, (int)valueId, (Type)keyType, (Type)valueType);
    }
}

