/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.grpc.Deadline;
import net.snowflake.client.jdbc.internal.grpc.ExperimentalApi;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.NameResolver;
import net.snowflake.client.jdbc.internal.grpc.internal.JsonUtil;
import net.snowflake.client.jdbc.internal.grpc.xds.WeightedRoundRobinLoadBalancer;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9885")
@Internal
public final class WeightedRoundRobinLoadBalancerProvider
extends LoadBalancerProvider {
    @VisibleForTesting
    static final long MIN_WEIGHT_UPDATE_PERIOD_NANOS = 100000000L;
    static final String SCHEME = "weighted_round_robin_experimental";

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new WeightedRoundRobinLoadBalancer(helper, Deadline.getSystemTicker());
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return SCHEME;
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        Long blackoutPeriodNanos = JsonUtil.getStringAsDuration(rawConfig, "blackoutPeriod");
        Long weightExpirationPeriodNanos = JsonUtil.getStringAsDuration(rawConfig, "weightExpirationPeriod");
        Long oobReportingPeriodNanos = JsonUtil.getStringAsDuration(rawConfig, "oobReportingPeriod");
        Boolean enableOobLoadReport = JsonUtil.getBoolean(rawConfig, "enableOobLoadReport");
        Long weightUpdatePeriodNanos = JsonUtil.getStringAsDuration(rawConfig, "weightUpdatePeriod");
        WeightedRoundRobinLoadBalancer.WeightedRoundRobinLoadBalancerConfig.Builder configBuilder = WeightedRoundRobinLoadBalancer.WeightedRoundRobinLoadBalancerConfig.newBuilder();
        if (blackoutPeriodNanos != null) {
            configBuilder.setBlackoutPeriodNanos(blackoutPeriodNanos);
        }
        if (weightExpirationPeriodNanos != null) {
            configBuilder.setWeightExpirationPeriodNanos(weightExpirationPeriodNanos);
        }
        if (enableOobLoadReport != null) {
            configBuilder.setEnableOobLoadReport(enableOobLoadReport);
        }
        if (oobReportingPeriodNanos != null) {
            configBuilder.setOobReportingPeriodNanos(oobReportingPeriodNanos);
        }
        if (weightUpdatePeriodNanos != null) {
            configBuilder.setWeightUpdatePeriodNanos(weightUpdatePeriodNanos);
            if (weightUpdatePeriodNanos < 100000000L) {
                configBuilder.setWeightUpdatePeriodNanos(100000000L);
            }
        }
        return NameResolver.ConfigOrError.fromConfig(configBuilder.build());
    }
}

