/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.memory.rounding;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.rounding.RoundingPolicy;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.util.CommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRoundingPolicy
implements RoundingPolicy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRoundingPolicy.class);
    public final long chunkSize;
    private static final int MIN_PAGE_SIZE = 4096;
    private static final int MAX_CHUNK_SIZE = 0x40000000;
    private static final long DEFAULT_CHUNK_SIZE;
    public static final DefaultRoundingPolicy DEFAULT_ROUNDING_POLICY;

    private static int validateAndCalculatePageShifts(int pageSize) {
        if (pageSize < 4096) {
            throw new IllegalArgumentException("pageSize: " + pageSize + " (expected: " + 4096 + ")");
        }
        if ((pageSize & pageSize - 1) != 0) {
            throw new IllegalArgumentException("pageSize: " + pageSize + " (expected: power of 2)");
        }
        return 31 - Integer.numberOfLeadingZeros(pageSize);
    }

    private static int validateAndCalculateChunkSize(int pageSize, int maxOrder) {
        if (maxOrder > 14) {
            throw new IllegalArgumentException("maxOrder: " + maxOrder + " (expected: 0-14)");
        }
        int chunkSize = pageSize;
        for (int i = maxOrder; i > 0; --i) {
            if (chunkSize > 0x20000000) {
                throw new IllegalArgumentException(String.format("pageSize (%d) << maxOrder (%d) must not exceed %d", pageSize, maxOrder, 0x40000000));
            }
            chunkSize <<= 1;
        }
        return chunkSize;
    }

    private DefaultRoundingPolicy(long chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Override
    public long getRoundedSize(long requestSize) {
        return requestSize < this.chunkSize ? CommonUtil.nextPowerOfTwo(requestSize) : requestSize;
    }

    static {
        int defaultPageSize = Integer.getInteger("net.snowflake.client.jdbc.internal.apache.memory.allocator.pageSize", 8192);
        try {
            DefaultRoundingPolicy.validateAndCalculatePageShifts(defaultPageSize);
        }
        catch (Throwable t2) {
            defaultPageSize = 8192;
        }
        int defaultMaxOrder = Integer.getInteger("net.snowflake.client.jdbc.internal.apache.memory.allocator.maxOrder", 11);
        try {
            DefaultRoundingPolicy.validateAndCalculateChunkSize(defaultPageSize, defaultMaxOrder);
        }
        catch (Throwable t3) {
            defaultMaxOrder = 11;
        }
        DEFAULT_CHUNK_SIZE = DefaultRoundingPolicy.validateAndCalculateChunkSize(defaultPageSize, defaultMaxOrder);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dorg.apache.memory.allocator.pageSize: {}", (Object)defaultPageSize);
            logger.debug("-Dorg.apache.memory.allocator.maxOrder: {}", (Object)defaultMaxOrder);
        }
        DEFAULT_ROUNDING_POLICY = new DefaultRoundingPolicy(DEFAULT_CHUNK_SIZE);
    }
}

