/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.rls;

import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.NameResolver;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.internal.JsonUtil;
import net.snowflake.client.jdbc.internal.grpc.rls.LbPolicyConfiguration;
import net.snowflake.client.jdbc.internal.grpc.rls.RlsLoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.rls.RlsProtoConverters;
import net.snowflake.client.jdbc.internal.grpc.rls.RlsProtoData;

@Internal
public final class RlsLoadBalancerProvider
extends LoadBalancerProvider {
    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 6;
    }

    @Override
    public String getPolicyName() {
        return "rls_experimental";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RlsLoadBalancer(helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingConfigPolicy) {
        try {
            RlsProtoData.RouteLookupConfig routeLookupConfig = (RlsProtoData.RouteLookupConfig)new RlsProtoConverters.RouteLookupConfigConverter().convert(JsonUtil.getObject(rawLoadBalancingConfigPolicy, "routeLookupConfig"));
            Map<String, ?> routeLookupChannelServiceConfig = JsonUtil.getObject(rawLoadBalancingConfigPolicy, "routeLookupChannelServiceConfig");
            LbPolicyConfiguration.ChildLoadBalancingPolicy lbPolicy = LbPolicyConfiguration.ChildLoadBalancingPolicy.create(JsonUtil.getString(rawLoadBalancingConfigPolicy, "childPolicyConfigTargetFieldName"), JsonUtil.checkObjectList(Preconditions.checkNotNull(JsonUtil.getList(rawLoadBalancingConfigPolicy, "childPolicy"))));
            return NameResolver.ConfigOrError.fromConfig(new LbPolicyConfiguration(routeLookupConfig, routeLookupChannelServiceConfig, lbPolicy));
        }
        catch (Exception e) {
            return NameResolver.ConfigOrError.fromError(Status.UNAVAILABLE.withDescription("can't parse config: " + e.getMessage()).withCause(e));
        }
    }
}

