/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.SQLException;
import java.util.Optional;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.BindingParameterMetadata;
import net.snowflake.client.jdbc.SnowflakeColumn;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class FieldSchemaCreator {
    static final SFLogger logger = SFLoggerFactory.getLogger(FieldSchemaCreator.class);
    public static final int MAX_TEXT_COLUMN_SIZE = 0x8000000;
    public static final int MAX_BINARY_COLUMN_SIZE = 0x4000000;

    public static BindingParameterMetadata buildSchemaForText(String fieldName, Optional<SnowflakeColumn> maybeColumn) {
        return BindingParameterMetadata.BindingParameterMetadataBuilder.bindingParameterMetadata().withType(maybeColumn.map(cl -> cl.type()).filter(str -> !str.isEmpty()).orElse("text")).withLength(maybeColumn.map(cl -> cl.length()).orElse(0x8000000)).withName(maybeColumn.map(cl -> cl.name()).filter(str -> !str.isEmpty()).orElse(fieldName)).build();
    }

    public static BindingParameterMetadata buildSchemaForBytesType(String fieldName, Optional<SnowflakeColumn> maybeColumn) {
        return BindingParameterMetadata.BindingParameterMetadataBuilder.bindingParameterMetadata().withType(maybeColumn.map(cl -> cl.type()).filter(str -> !str.isEmpty()).orElse("binary")).withName(maybeColumn.map(cl -> cl.name()).filter(str -> !str.isEmpty()).orElse(fieldName)).withLength(maybeColumn.map(cl -> cl.precision()).orElse(0x8000000)).withByteLength(maybeColumn.map(cl -> cl.byteLength()).orElse(0x4000000)).build();
    }

    public static BindingParameterMetadata buildSchemaTypeAndNameOnly(String fieldName, String type, Optional<SnowflakeColumn> maybeColumn) {
        return BindingParameterMetadata.BindingParameterMetadataBuilder.bindingParameterMetadata().withType(maybeColumn.map(cl -> cl.type()).filter(str -> !str.isEmpty()).orElse(type)).withName(maybeColumn.map(cl -> cl.name()).filter(str -> !str.isEmpty()).orElse(fieldName)).build();
    }

    public static BindingParameterMetadata buildSchemaWithScaleAndPrecision(String fieldName, String type, int scale, int precision, Optional<SnowflakeColumn> maybeColumn) {
        return BindingParameterMetadata.BindingParameterMetadataBuilder.bindingParameterMetadata().withType(maybeColumn.map(cl -> cl.type()).filter(str -> !str.isEmpty()).orElse(type)).withScale(maybeColumn.map(cl -> cl.scale()).filter(i -> i > 0).orElse(scale)).withName(maybeColumn.map(cl -> cl.name()).filter(str -> !str.isEmpty()).orElse(fieldName)).withPrecision(maybeColumn.map(cl -> cl.precision()).filter(i -> i > 0).orElse(precision)).build();
    }

    public static BindingParameterMetadata buildBindingSchemaForType(int baseType) throws SQLException {
        return FieldSchemaCreator.buildBindingSchemaForType(baseType, true);
    }

    public static BindingParameterMetadata buildBindingSchemaForType(int baseType, boolean addName) throws SQLException {
        String name = addName ? SnowflakeType.javaTypeToSFType(baseType, null).name() : null;
        switch (baseType) {
            case 1: 
            case 12: {
                return FieldSchemaCreator.buildSchemaForText(name, Optional.empty());
            }
            case 3: 
            case 6: 
            case 8: {
                return FieldSchemaCreator.buildSchemaWithScaleAndPrecision(name, "real", 9, 38, Optional.empty());
            }
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                return FieldSchemaCreator.buildSchemaWithScaleAndPrecision(null, "fixed", 0, 38, Optional.empty());
            }
            case 16: {
                return FieldSchemaCreator.buildSchemaTypeAndNameOnly(name, "boolean", Optional.empty());
            }
            case 91: {
                return FieldSchemaCreator.buildSchemaTypeAndNameOnly(name, "date", Optional.empty());
            }
            case 92: 
            case 93: {
                return FieldSchemaCreator.buildSchemaWithScaleAndPrecision(name, "timestamp", 9, 0, Optional.empty());
            }
        }
        logger.error("Could not create schema for type : " + baseType, new Object[0]);
        throw new SQLException("Could not create schema for type : " + baseType);
    }
}

