/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.IOException;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.cloud.ReadChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobInfo;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ByteRangeSpec;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageException;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;

interface StorageReadChannel
extends ReadChannel {
    public StorageReadChannel setByteRangeSpec(ByteRangeSpec var1);

    public ApiFuture<BlobInfo> getObject();

    default public ByteRangeSpec getByteRangeSpec() {
        return ByteRangeSpec.nullRange();
    }

    @Override
    @Deprecated
    default public void seek(long position) throws IOException {
        try {
            this.setByteRangeSpec(this.getByteRangeSpec().withNewBeginOffset(position));
        }
        catch (StorageException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    @Override
    @Deprecated
    default public ReadChannel limit(long limit) {
        Preconditions.checkArgument(limit >= 0L, "limit must be >= 0");
        this.setByteRangeSpec(this.getByteRangeSpec().withNewEndOffset(limit));
        return this;
    }

    @Override
    @Deprecated
    default public long limit() {
        return this.getByteRangeSpec().endOffset();
    }
}

