/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationScopeInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.export.MemoryMode;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.AggregationTemporality;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.LongExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.LongPointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.MetricData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.concurrent.AdderUtil;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.concurrent.LongAdder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.MutableLongPointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.Measurement;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.resources.Resource;

public final class LongSumAggregator
extends AbstractSumAggregator<LongPointData, LongExemplarData> {
    private final Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier;
    private final MemoryMode memoryMode;

    public LongSumAggregator(InstrumentDescriptor instrumentDescriptor, Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier, MemoryMode memoryMode) {
        super(instrumentDescriptor);
        this.reservoirSupplier = reservoirSupplier;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<LongPointData, LongExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get(), this.memoryMode);
    }

    @Override
    public LongPointData diff(LongPointData previousPoint, LongPointData currentPoint) {
        return ImmutableLongPointData.create(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousPoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public void diffInPlace(LongPointData previousReusablePoint, LongPointData currentPoint) {
        ((MutableLongPointData)previousReusablePoint).set(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousReusablePoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public LongPointData toPoint(Measurement measurement) {
        return ImmutableLongPointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.longValue());
    }

    @Override
    public void toPoint(Measurement measurement, LongPointData reusablePoint) {
        ((MutableLongPointData)reusablePoint).set(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.longValue());
    }

    @Override
    public LongPointData createReusablePoint() {
        return new MutableLongPointData();
    }

    @Override
    public void copyPoint(LongPointData point, LongPointData toReusablePoint) {
        ((MutableLongPointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<LongPointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createLongSum(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableSumData.create(this.isMonotonic(), temporality, points));
    }

    static final class Handle
    extends AggregatorHandle<LongPointData, LongExemplarData> {
        private final LongAdder current = AdderUtil.createLongAdder();
        @Nullable
        private final MutableLongPointData reusablePointData;

        Handle(ExemplarReservoir<LongExemplarData> exemplarReservoir, MemoryMode memoryMode) {
            super(exemplarReservoir);
            this.reusablePointData = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableLongPointData() : null;
        }

        @Override
        protected LongPointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<LongExemplarData> exemplars, boolean reset) {
            long value;
            long l = value = reset ? this.current.sumThenReset() : this.current.sum();
            if (this.reusablePointData != null) {
                this.reusablePointData.set(startEpochNanos, epochNanos, attributes, value, exemplars);
                return this.reusablePointData;
            }
            return ImmutableLongPointData.create(startEpochNanos, epochNanos, attributes, value, exemplars);
        }

        @Override
        public void doRecordLong(long value) {
            this.current.add(value);
        }
    }
}

