/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view;

import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.Clock;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.export.MemoryMode;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.RandomSupplier;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.Aggregation;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentType;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.ExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.LongExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.PointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.DoubleLastValueAggregator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.LongLastValueAggregator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;

public final class LastValueAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation INSTANCE = new LastValueAggregation();

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private LastValueAggregation() {
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter, MemoryMode memoryMode) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                Supplier<ExemplarReservoir<LongExemplarData>> reservoirFactory = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.longFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new LongLastValueAggregator(reservoirFactory, memoryMode);
            }
            case DOUBLE: {
                Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirFactory = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.doubleFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new DoubleLastValueAggregator(reservoirFactory, memoryMode);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        InstrumentType instrumentType = instrumentDescriptor.getType();
        return instrumentType == InstrumentType.OBSERVABLE_GAUGE || instrumentType == InstrumentType.GAUGE;
    }

    public String toString() {
        return "LastValueAggregation";
    }
}

