/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.snowflake.client.jdbc.internal.google.api.MetricDescriptor;

public interface MetricDescriptorStrategy {
    public static final MetricDescriptorStrategy ALWAYS_SEND = new MetricDescriptorStrategy(){

        @Override
        public void exportDescriptors(Iterable<MetricDescriptor> batchDescriptors, Consumer<MetricDescriptor> export) {
            for (MetricDescriptor descriptor : batchDescriptors) {
                export.accept(descriptor);
            }
        }
    };
    public static final MetricDescriptorStrategy NEVER_SEND = new MetricDescriptorStrategy(){

        @Override
        public void exportDescriptors(Iterable<MetricDescriptor> batchDescriptors, Consumer<MetricDescriptor> export) {
        }
    };
    public static final MetricDescriptorStrategy SEND_ONCE = new MetricDescriptorStrategy(){
        private final Set<String> alreadySent = new HashSet<String>();

        @Override
        public synchronized void exportDescriptors(Iterable<MetricDescriptor> batchDescriptors, Consumer<MetricDescriptor> export) {
            for (MetricDescriptor descriptor : batchDescriptors) {
                if (this.alreadySent.contains(descriptor.getType())) continue;
                export.accept(descriptor);
                this.alreadySent.add(descriptor.getType());
            }
        }
    };

    public void exportDescriptors(Iterable<MetricDescriptor> var1, Consumer<MetricDescriptor> var2);
}

