/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import net.snowflake.client.core.SnowflakeJdbcInternalApi;

@SnowflakeJdbcInternalApi
public class RetryContext {
    static final int SECONDS_TO_MILLIS_FACTOR = 1000;
    private long elapsedTimeInMillis;
    private long retryTimeoutInMillis;
    private long retryCount;

    public RetryContext setElapsedTimeInMillis(long elapsedTimeInMillis) {
        this.elapsedTimeInMillis = elapsedTimeInMillis;
        return this;
    }

    public RetryContext setRetryTimeoutInMillis(long retryTimeoutInMillis) {
        this.retryTimeoutInMillis = retryTimeoutInMillis;
        return this;
    }

    public RetryContext setRetryCount(long retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    private long getRemainingRetryTimeoutInMillis() {
        return this.retryTimeoutInMillis - this.elapsedTimeInMillis;
    }

    public long getRemainingRetryTimeoutInSeconds() {
        return this.getRemainingRetryTimeoutInMillis() / 1000L;
    }

    public long getRetryCount() {
        return this.retryCount;
    }
}

