/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpResponseContextDto;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.RestRequest;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.CommonObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.EncryptionProvider;
import net.snowflake.client.jdbc.cloud.storage.GCSAccessStrategy;
import net.snowflake.client.jdbc.cloud.storage.GCSAccessStrategyAwsSdk;
import net.snowflake.client.jdbc.cloud.storage.GCSDefaultAccessStrategy;
import net.snowflake.client.jdbc.cloud.storage.QueryIdHelper;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.cloud.storage.StorageHelper;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummaryCollection;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.http.client.HttpResponseException;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPut;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.entity.InputStreamEntity;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.util.EntityUtils;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SFPair;
import net.snowflake.client.util.Stopwatch;

public class SnowflakeGCSClient
implements SnowflakeStorageClient {
    @SnowflakeJdbcInternalApi
    public static final String DISABLE_GCS_DEFAULT_CREDENTIALS_PROPERTY_NAME = "net.snowflake.jdbc.disableGcsDefaultCredentials";
    private static final String GCS_ENCRYPTIONDATAPROP = "encryptiondata";
    private static final String localFileSep = SnowflakeUtil.systemGetProperty("file.separator");
    private static final String GCS_METADATA_PREFIX = "x-goog-meta-";
    private static final String GCS_STREAMING_INGEST_CLIENT_NAME = "ingestclientname";
    private static final String GCS_STREAMING_INGEST_CLIENT_KEY = "ingestclientkey";
    private int encryptionKeySize = 0;
    private StageInfo stageInfo;
    private RemoteStoreFileEncryptionMaterial encMat;
    private SFSession session = null;
    private GCSAccessStrategy gcsAccessStrategy = null;
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeGCSClient.class);

    private SnowflakeGCSClient() {
    }

    public static SnowflakeGCSClient createSnowflakeGCSClient(StageInfo stage, RemoteStoreFileEncryptionMaterial encMat, SFSession session) throws SnowflakeSQLException {
        logger.debug("Initializing Snowflake GCS client with encryption: {}", encMat != null ? "true" : "false");
        SnowflakeGCSClient sfGcsClient = new SnowflakeGCSClient();
        sfGcsClient.setupGCSClient(stage, encMat, session);
        return sfGcsClient;
    }

    @Override
    public int getMaxRetries() {
        if (this.session != null && this.session.getConnectionPropertiesMap().containsKey((Object)SFSessionProperty.PUT_GET_MAX_RETRIES)) {
            return (Integer)this.session.getConnectionPropertiesMap().get((Object)SFSessionProperty.PUT_GET_MAX_RETRIES);
        }
        return 25;
    }

    @Override
    public int getRetryBackoffMaxExponent() {
        return 4;
    }

    @Override
    public int getRetryBackoffMin() {
        return 1000;
    }

    @Override
    public boolean isEncrypting() {
        return this.encryptionKeySize > 0 && this.stageInfo.getIsClientSideEncrypted();
    }

    @Override
    public int getEncryptionKeySize() {
        return this.encryptionKeySize;
    }

    @Override
    public boolean requirePresignedUrl() {
        Map<?, ?> credentialsMap = this.stageInfo.getCredentials();
        return credentialsMap == null || !credentialsMap.containsKey("GCS_ACCESS_TOKEN");
    }

    @Override
    public void renew(Map<?, ?> stageCredentials) throws SnowflakeSQLException {
        logger.debug("Renewing the Snowflake GCS client", new Object[0]);
        this.stageInfo.setCredentials(stageCredentials);
        this.setupGCSClient(this.stageInfo, this.encMat, this.session);
    }

    @Override
    public void shutdown() {
        if (this.gcsAccessStrategy != null) {
            this.gcsAccessStrategy.shutdown();
        }
    }

    @Override
    public StorageObjectSummaryCollection listObjects(String remoteStorageLocation, String prefix) throws StorageProviderException {
        return this.gcsAccessStrategy.listObjects(remoteStorageLocation, prefix);
    }

    @Override
    public StorageObjectMetadata getObjectMetadata(String remoteStorageLocation, String prefix) throws StorageProviderException {
        return this.gcsAccessStrategy.getObjectMetadata(remoteStorageLocation, prefix);
    }

    @Override
    public void download(SFSession session, String command, String localLocation, String destFileName, int parallelism, String remoteStorageLocation, String stageFilePath, String stageRegion, String presignedUrl, String queryId) throws SnowflakeSQLException {
        String localFilePath = localLocation + localFileSep + destFileName;
        logger.debug("Staring download of file from GCS stage path: {} to {}", stageFilePath, localFilePath);
        int retryCount = 0;
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        File localFile = new File(localFilePath);
        while (true) {
            try {
                String key = null;
                String iv = null;
                long downloadMillis = 0L;
                if (!SnowflakeUtil.isNullOrEmpty(presignedUrl)) {
                    logger.debug("Starting download with presigned URL", false);
                    URIBuilder uriBuilder = new URIBuilder(presignedUrl);
                    HttpGet httpRequest = new HttpGet(uriBuilder.build());
                    httpRequest.addHeader("accept-encoding", "GZIP");
                    logger.debug("Fetching result: {}", this.scrubPresignedUrl(presignedUrl));
                    CloseableHttpClient httpClient = HttpUtil.getHttpClientWithoutDecompression(session.getHttpClientKey(), session.getHttpHeadersCustomizers());
                    HttpResponseContextDto responseDto = RestRequest.executeWithRetries(httpClient, httpRequest, session.getNetworkTimeoutInMilli() / 1000, 0L, session.getHttpClientSocketTimeout(), this.getMaxRetries(), 0, null, false, false, false, true, false, new ExecTimeTelemetryData(), session, session.getHttpClientKey(), session.getHttpHeadersCustomizers(), true);
                    CloseableHttpResponse response = responseDto.getHttpResponse();
                    logger.debug("Call returned for URL: {}", () -> this.scrubPresignedUrl(this.stageInfo.getPresignedUrl()));
                    if (SnowflakeGCSClient.isSuccessStatusCode(response.getStatusLine().getStatusCode())) {
                        try {
                            int bytesRead;
                            InputStream bodyStream = response.getEntity().getContent();
                            byte[] buffer = new byte[8192];
                            FileOutputStream outStream = new FileOutputStream(localFile);
                            while ((bytesRead = bodyStream.read(buffer)) != -1) {
                                ((OutputStream)outStream).write(buffer, 0, bytesRead);
                            }
                            outStream.flush();
                            ((OutputStream)outStream).close();
                            bodyStream.close();
                            SnowflakeUtil.assureOnlyUserAccessibleFilePermissions(localFile, session.isOwnerOnlyStageFilePermissionsEnabled());
                            if (this.isEncrypting()) {
                                Map<String, String> userDefinedHeaders = SnowflakeUtil.createCaseInsensitiveMap(response.getAllHeaders());
                                AbstractMap.SimpleEntry<String, String> encryptionData = this.parseEncryptionData(userDefinedHeaders.get("x-goog-meta-encryptiondata"), queryId);
                                key = encryptionData.getKey();
                                iv = encryptionData.getValue();
                            }
                            stopwatch.stop();
                            downloadMillis = stopwatch.elapsedMillis();
                            logger.debug("Download successful", false);
                        }
                        catch (IOException ex) {
                            logger.debug("Download unsuccessful {}", ex);
                            this.handleStorageException(ex, ++retryCount, "download", session, command, queryId);
                        }
                    } else {
                        HttpResponseException ex = new HttpResponseException(response.getStatusLine().getStatusCode(), EntityUtils.toString(response.getEntity()));
                        this.handleStorageException(ex, ++retryCount, "download", session, command, queryId);
                    }
                } else {
                    Map<String, String> userDefinedMetadata = this.gcsAccessStrategy.download(parallelism, remoteStorageLocation, stageFilePath, localFile);
                    SnowflakeUtil.assureOnlyUserAccessibleFilePermissions(localFile, session.isOwnerOnlyStageFilePermissionsEnabled());
                    stopwatch.stop();
                    downloadMillis = stopwatch.elapsedMillis();
                    logger.debug("Download successful", false);
                    if (this.isEncrypting() && !userDefinedMetadata.isEmpty()) {
                        AbstractMap.SimpleEntry<String, String> encryptionData = this.parseEncryptionData(userDefinedMetadata.get(GCS_ENCRYPTIONDATAPROP), queryId);
                        key = encryptionData.getKey();
                        iv = encryptionData.getValue();
                    }
                }
                if (!SnowflakeUtil.isNullOrEmpty(iv) && !SnowflakeUtil.isNullOrEmpty(key) && this.isEncrypting() && this.getEncryptionKeySize() <= 256) {
                    if (key == null || iv == null) {
                        throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)StorageHelper.getOperationException("download").getMessageCode(), "XX000", "File metadata incomplete");
                    }
                    try {
                        stopwatch.start();
                        EncryptionProvider.decrypt(localFile, key, iv, this.encMat);
                        stopwatch.stop();
                        long decryptMillis = stopwatch.elapsedMillis();
                        logger.info("GCS file {} downloaded to {}. It took {} ms (download: {} ms, decryption: {} ms) with {} retries", stageFilePath, localFile.getAbsolutePath(), downloadMillis + decryptMillis, downloadMillis, decryptMillis, retryCount);
                    }
                    catch (Exception ex) {
                        logger.error("Error decrypting file", ex);
                        throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)StorageHelper.getOperationException("download").getMessageCode(), "XX000", "Cannot decrypt file");
                    }
                } else {
                    logger.info("GCS file {} downloaded to {}. It took {} ms with {} retries", stageFilePath, localFile.getAbsolutePath(), downloadMillis, retryCount);
                }
                return;
            }
            catch (Exception ex) {
                logger.debug("Download unsuccessful {}", ex);
                this.handleStorageException(ex, ++retryCount, "download", session, command, queryId);
                if (retryCount <= this.getMaxRetries()) continue;
                throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)StorageHelper.getOperationException("download").getMessageCode(), "XX000", "Unexpected: download unsuccessful without exception!");
            }
            break;
        }
    }

    @Override
    public InputStream downloadToStream(SFSession session, String command, int parallelism, String remoteStorageLocation, String stageFilePath, String stageRegion, String presignedUrl, String queryId) throws SnowflakeSQLException {
        logger.debug("Staring download of file from GCS stage path: {} to input stream", stageFilePath);
        int retryCount = 0;
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        InputStream inputStream = null;
        long downloadMillis = 0L;
        while (true) {
            try {
                block16: {
                    String key = null;
                    String iv = null;
                    if (!SnowflakeUtil.isNullOrEmpty(presignedUrl)) {
                        logger.debug("Starting download with presigned URL", false);
                        URIBuilder uriBuilder = new URIBuilder(presignedUrl);
                        HttpGet httpRequest = new HttpGet(uriBuilder.build());
                        httpRequest.addHeader("accept-encoding", "GZIP");
                        logger.debug("Fetching result: {}", this.scrubPresignedUrl(presignedUrl));
                        CloseableHttpClient httpClient = HttpUtil.getHttpClientWithoutDecompression(session.getHttpClientKey(), session.getHttpHeadersCustomizers());
                        CloseableHttpResponse response = RestRequest.executeWithRetries(httpClient, httpRequest, session.getNetworkTimeoutInMilli() / 1000, 0L, session.getHttpClientSocketTimeout(), this.getMaxRetries(), 0, null, false, false, false, true, false, new ExecTimeTelemetryData(), session, session.getHttpClientKey(), session.getHttpHeadersCustomizers(), true).getHttpResponse();
                        logger.debug("Call returned for URL: {}", () -> this.scrubPresignedUrl(this.stageInfo.getPresignedUrl()));
                        if (SnowflakeGCSClient.isSuccessStatusCode(response.getStatusLine().getStatusCode())) {
                            try {
                                inputStream = response.getEntity().getContent();
                                if (this.isEncrypting()) {
                                    Map<String, String> userDefinedHeaders = SnowflakeUtil.createCaseInsensitiveMap(response.getAllHeaders());
                                    AbstractMap.SimpleEntry<String, String> encryptionData = this.parseEncryptionData(userDefinedHeaders.get("x-goog-meta-encryptiondata"), queryId);
                                    key = encryptionData.getKey();
                                    iv = encryptionData.getValue();
                                }
                                stopwatch.stop();
                                downloadMillis = stopwatch.elapsedMillis();
                                logger.debug("Download successful", false);
                            }
                            catch (IOException ex) {
                                logger.debug("Download unsuccessful {}", ex);
                                this.handleStorageException(ex, ++retryCount, "download", session, command, queryId);
                            }
                        } else {
                            HttpResponseException ex = new HttpResponseException(response.getStatusLine().getStatusCode(), EntityUtils.toString(response.getEntity()));
                            this.handleStorageException(ex, ++retryCount, "download", session, command, queryId);
                        }
                    } else {
                        SFPair<InputStream, Map<String, String>> pair = this.gcsAccessStrategy.downloadToStream(remoteStorageLocation, stageFilePath, this.isEncrypting());
                        inputStream = (InputStream)pair.left;
                        if (this.isEncrypting()) {
                            Map userDefinedMetadata = (Map)pair.right;
                            AbstractMap.SimpleEntry<String, String> encryptionData = this.parseEncryptionData((String)userDefinedMetadata.get(GCS_ENCRYPTIONDATAPROP), queryId);
                            key = encryptionData.getKey();
                            iv = encryptionData.getValue();
                        }
                        stopwatch.stop();
                        downloadMillis = stopwatch.elapsedMillis();
                    }
                    if (this.isEncrypting() && this.getEncryptionKeySize() <= 256) {
                        stopwatch.restart();
                        if (key == null || iv == null) {
                            throw new SnowflakeSQLException(queryId, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "File metadata incomplete");
                        }
                        try {
                            if (inputStream != null) {
                                inputStream = EncryptionProvider.decryptStream(inputStream, key, iv, this.encMat);
                                stopwatch.stop();
                                long decryptMillis = stopwatch.elapsedMillis();
                                logger.info("GCS file {} downloaded to stream. It took {} ms (download: {} ms, decryption: {} ms) with {} retries", stageFilePath, downloadMillis + decryptMillis, downloadMillis, decryptMillis, retryCount);
                                return inputStream;
                            }
                            break block16;
                        }
                        catch (Exception ex) {
                            logger.error("Error decrypting file", ex);
                            throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)StorageHelper.getOperationException("download").getMessageCode(), "XX000", "Cannot decrypt file");
                        }
                    }
                    logger.info("GCS file {} downloaded to stream. Download took {} ms with {} retries", stageFilePath, downloadMillis, retryCount);
                }
                return inputStream;
            }
            catch (Exception ex) {
                logger.debug("Download unsuccessful {}", ex);
                this.handleStorageException(ex, ++retryCount, "download", session, command, queryId);
                if (retryCount <= this.getMaxRetries()) continue;
                throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)StorageHelper.getOperationException("download").getMessageCode(), "XX000", "Unexpected: download unsuccessful without exception!");
            }
            break;
        }
    }

    @Override
    public void uploadWithPresignedUrlWithoutConnection(int networkTimeoutInMilli, HttpClientSettingsKey ocspModeAndProxyKey, int parallelism, boolean uploadFromStream, String remoteStorageLocation, File srcFile, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, StorageObjectMetadata meta, String stageRegion, String presignedUrl, String queryId) throws SnowflakeSQLException {
        logger.info(StorageHelper.getStartUploadLog("GCS", uploadFromStream, inputStream, fileBackedOutputStream, srcFile, destFileName), new Object[0]);
        ArrayList<FileInputStream> toClose = new ArrayList<FileInputStream>();
        long originalContentLength = meta.getContentLength();
        SFPair<InputStream, Boolean> uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, meta, originalContentLength, fileBackedOutputStream, toClose, queryId);
        if (!(meta instanceof CommonObjectMetadata)) {
            throw new IllegalArgumentException("Unexpected metadata object type");
        }
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        if (SnowflakeUtil.isNullOrEmpty(presignedUrl) || "null".equalsIgnoreCase(presignedUrl)) {
            logger.debug("Starting upload with downscoped token", new Object[0]);
            this.uploadWithDownScopedToken(parallelism, remoteStorageLocation, destFileName, meta.getContentEncoding(), meta.getUserMetadata(), meta.getContentLength(), (InputStream)uploadStreamInfo.left, queryId);
            logger.debug("Upload successful with downscoped token", new Object[0]);
        } else {
            logger.debug("Starting upload with presigned url", new Object[0]);
            this.uploadWithPresignedUrl(networkTimeoutInMilli, (int)HttpUtil.getSocketTimeout().toMillis(), meta.getContentEncoding(), meta.getUserMetadata(), (InputStream)uploadStreamInfo.left, presignedUrl, ocspModeAndProxyKey, queryId);
            logger.debug("Upload successfully with presigned url", new Object[0]);
        }
        stopwatch.stop();
        if (uploadFromStream) {
            logger.info("Uploaded data from input stream to GCS location: {}. It took {} ms", remoteStorageLocation, stopwatch.elapsedMillis());
        } else {
            logger.info("Uploaded file {} to GCS location: {}. It took {} ms", srcFile.getAbsolutePath(), remoteStorageLocation, stopwatch.elapsedMillis());
        }
        for (FileInputStream is : toClose) {
            IOUtils.closeQuietly(is);
        }
    }

    @Override
    public void upload(SFSession session, String command, int parallelism, boolean uploadFromStream, String remoteStorageLocation, File srcFile, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, StorageObjectMetadata meta, String stageRegion, String presignedUrl, String queryId) throws SnowflakeSQLException {
        logger.info(StorageHelper.getStartUploadLog("GCS", uploadFromStream, inputStream, fileBackedOutputStream, srcFile, destFileName), new Object[0]);
        ArrayList<FileInputStream> toClose = new ArrayList<FileInputStream>();
        long originalContentLength = meta.getContentLength();
        SFPair<InputStream, Boolean> uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, meta, originalContentLength, fileBackedOutputStream, toClose, queryId);
        if (!(meta instanceof CommonObjectMetadata)) {
            throw new IllegalArgumentException("Unexpected metadata object type");
        }
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        if (!SnowflakeUtil.isNullOrEmpty(presignedUrl)) {
            logger.debug("Starting upload with downscope token", false);
            this.uploadWithPresignedUrl(session.getNetworkTimeoutInMilli(), session.getHttpClientSocketTimeout(), meta.getContentEncoding(), meta.getUserMetadata(), (InputStream)uploadStreamInfo.left, presignedUrl, session.getHttpClientKey(), queryId);
            stopwatch.stop();
            logger.debug("Upload successful", false);
            if (uploadFromStream) {
                logger.info("Uploaded data from input stream to GCS location: {}. It took {} ms", remoteStorageLocation, stopwatch.elapsedMillis());
            } else {
                logger.info("Uploaded file {} to GCS location: {}. It took {} ms", srcFile.getAbsolutePath(), remoteStorageLocation, stopwatch.elapsedMillis());
            }
            for (FileInputStream is : toClose) {
                IOUtils.closeQuietly(is);
            }
            return;
        }
        int retryCount = 0;
        while (true) {
            try {
                logger.debug("Starting upload", false);
                this.uploadWithDownScopedToken(parallelism, remoteStorageLocation, destFileName, meta.getContentEncoding(), meta.getUserMetadata(), meta.getContentLength(), (InputStream)uploadStreamInfo.left, queryId);
                stopwatch.stop();
                logger.debug("Upload successful", false);
                if (uploadFromStream) {
                    logger.info("Uploaded data from input stream to GCS location: {}. It took {} ms", remoteStorageLocation, stopwatch.elapsedMillis());
                } else {
                    logger.info("Uploaded file {} to GCS location: {}. It took {} ms", srcFile.getAbsolutePath(), remoteStorageLocation, stopwatch.elapsedMillis());
                }
                for (FileInputStream is : toClose) {
                    IOUtils.closeQuietly(is);
                }
                return;
            }
            catch (Exception ex) {
                this.handleStorageException(ex, ++retryCount, "upload", session, command, queryId);
                if (uploadFromStream && fileBackedOutputStream == null) {
                    throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)StorageHelper.getOperationException("upload").getMessageCode(), ex, "Encountered exception during upload: " + ex.getMessage() + "\nCannot retry upload from stream.");
                }
                uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, meta, originalContentLength, fileBackedOutputStream, toClose, queryId);
                if (retryCount <= this.getMaxRetries()) continue;
                for (FileInputStream is : toClose) {
                    IOUtils.closeQuietly(is);
                }
                throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, (int)StorageHelper.getOperationException("upload").getMessageCode(), "XX000", "Unexpected: upload unsuccessful without exception!");
            }
            break;
        }
    }

    private void uploadWithDownScopedToken(int parallelism, String remoteStorageLocation, String destFileName, String contentEncoding, Map<String, String> metadata, long contentLength, InputStream content, String queryId) throws SnowflakeSQLException {
        logger.debug("Uploading file {} to bucket {}", destFileName, remoteStorageLocation);
        try {
            this.gcsAccessStrategy.uploadWithDownScopedToken(parallelism, remoteStorageLocation, destFileName, contentEncoding, metadata, contentLength, content, queryId);
        }
        catch (Exception e) {
            this.handleStorageException(e, 0, "upload", this.session, queryId);
            SnowflakeSQLException wrappedException = e instanceof SnowflakeSQLException ? (SnowflakeSQLException)e : new SnowflakeSQLLoggedException(queryId, (SFBaseSession)this.session, "58000", (int)StorageHelper.getOperationException("upload").getMessageCode(), e, "Encountered exception during upload: " + e.getMessage());
            throw wrappedException;
        }
    }

    private void uploadWithPresignedUrl(int networkTimeoutInMilli, int httpClientSocketTimeout, String contentEncoding, Map<String, String> metadata, InputStream content, String presignedUrl, HttpClientSettingsKey ocspAndProxyKey, String queryId) throws SnowflakeSQLException {
        try {
            URIBuilder uriBuilder = new URIBuilder(presignedUrl);
            HttpPut httpRequest = new HttpPut(uriBuilder.build());
            logger.debug("Fetching result: {}", this.scrubPresignedUrl(presignedUrl));
            if ("gzip".equals(contentEncoding)) {
                contentEncoding = "";
            }
            httpRequest.addHeader("content-encoding", contentEncoding);
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                httpRequest.addHeader(GCS_METADATA_PREFIX + entry.getKey(), entry.getValue());
            }
            InputStreamEntity contentEntity = new InputStreamEntity(content, -1L);
            httpRequest.setEntity(contentEntity);
            CloseableHttpClient httpClient = HttpUtil.getHttpClient(ocspAndProxyKey, this.session.getHttpHeadersCustomizers());
            CloseableHttpResponse response = RestRequest.executeWithRetries(httpClient, httpRequest, networkTimeoutInMilli / 1000, 0L, httpClientSocketTimeout, this.getMaxRetries(), 0, null, false, false, false, true, true, new ExecTimeTelemetryData(), this.session, ocspAndProxyKey, this.session.getHttpHeadersCustomizers(), false).getHttpResponse();
            logger.debug("Call returned for URL: {}", () -> this.scrubPresignedUrl(this.stageInfo.getPresignedUrl()));
            if (!SnowflakeGCSClient.isSuccessStatusCode(response.getStatusLine().getStatusCode())) {
                HttpResponseException ex = new HttpResponseException(response.getStatusLine().getStatusCode(), EntityUtils.toString(response.getEntity()));
                this.handleStorageException(ex, 0, "upload", this.session, null, queryId);
            }
        }
        catch (URISyntaxException e) {
            throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)this.session, (int)StorageHelper.getOperationException("upload").getMessageCode(), "XX000", "Unexpected: upload presigned URL invalid");
        }
        catch (Exception e) {
            throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)this.session, (int)StorageHelper.getOperationException("upload").getMessageCode(), "XX000", "Unexpected: upload with presigned url failed");
        }
    }

    private String scrubPresignedUrl(String presignedUrl) {
        if (SnowflakeUtil.isNullOrEmpty(presignedUrl)) {
            return "";
        }
        int indexOfQueryString = presignedUrl.lastIndexOf("?");
        indexOfQueryString = indexOfQueryString > 0 ? indexOfQueryString : presignedUrl.length() - 1;
        return presignedUrl.substring(0, indexOfQueryString);
    }

    private SFPair<InputStream, Boolean> createUploadStream(File srcFile, boolean uploadFromStream, InputStream inputStream, StorageObjectMetadata meta, long originalContentLength, FileBackedOutputStream fileBackedOutputStream, List<FileInputStream> toClose, String queryId) throws SnowflakeSQLException {
        InputStream stream;
        block10: {
            logger.debug("createUploadStream({}, {}, {}, {}, {}, {})", this, srcFile, uploadFromStream, inputStream, fileBackedOutputStream, toClose);
            FileInputStream srcFileStream = null;
            try {
                if (this.isEncrypting() && this.getEncryptionKeySize() <= 256) {
                    try {
                        InputStream inputStream2;
                        if (uploadFromStream) {
                            inputStream2 = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
                        } else {
                            srcFileStream = new FileInputStream(srcFile);
                            inputStream2 = srcFileStream;
                        }
                        InputStream uploadStream = inputStream2;
                        toClose.add(srcFileStream);
                        stream = EncryptionProvider.encrypt(meta, originalContentLength, uploadStream, this.encMat, this);
                        uploadFromStream = true;
                        break block10;
                    }
                    catch (Exception ex) {
                        logger.error("Failed to encrypt input", ex);
                        throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)this.session, "XX000", (int)StorageHelper.getOperationException("upload").getMessageCode(), ex, "Failed to encrypt input", ex.getMessage());
                    }
                }
                if (uploadFromStream) {
                    stream = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
                } else {
                    srcFileStream = new FileInputStream(srcFile);
                    toClose.add(srcFileStream);
                    stream = srcFileStream;
                }
            }
            catch (FileNotFoundException ex) {
                logger.error("Failed to open input file", ex);
                throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)this.session, "XX000", (int)StorageHelper.getOperationException("upload").getMessageCode(), ex, "Failed to open input file", ex.getMessage());
            }
            catch (IOException ex) {
                logger.error("Failed to open input stream", ex);
                throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)this.session, "XX000", (int)StorageHelper.getOperationException("upload").getMessageCode(), ex, "Failed to open input stream", ex.getMessage());
            }
        }
        return SFPair.of(stream, uploadFromStream);
    }

    @Override
    public void handleStorageException(Exception ex, int retryCount, String operation, SFSession session, String command, String queryId) throws SnowflakeSQLException {
        if (ex.getCause() instanceof InvalidKeyException) {
            SnowflakeFileTransferAgent.throwJCEMissingError(operation, ex, queryId);
        }
        if (SnowflakeUtil.getRootCause(ex) instanceof IOException) {
            SnowflakeFileTransferAgent.throwNoSpaceLeftError(session, operation, ex, queryId);
        }
        if (!this.gcsAccessStrategy.handleStorageException(ex, retryCount, operation, session, command, queryId, this)) {
            if (ex instanceof InterruptedException || SnowflakeUtil.getRootCause(ex) instanceof SocketTimeoutException) {
                if (retryCount > this.getMaxRetries()) {
                    throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)StorageHelper.getOperationException(operation).getMessageCode(), ex, "Encountered exception during " + operation + ": " + ex.getMessage());
                }
                logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
            } else {
                throw new SnowflakeSQLLoggedException(queryId, (SFBaseSession)session, "58000", (int)StorageHelper.getOperationException(operation).getMessageCode(), ex, "Encountered exception during " + operation + ": " + ex.getMessage());
            }
        }
    }

    @Override
    public String getMatdescKey() {
        return "matdesc";
    }

    @Override
    public void addEncryptionMetadata(StorageObjectMetadata meta, MatDesc matDesc, byte[] ivData, byte[] encryptedKey, long contentLength) {
        meta.addUserMetadata(this.getMatdescKey(), matDesc.toString());
        meta.addUserMetadata(GCS_ENCRYPTIONDATAPROP, this.buildEncryptionMetadataJSON(Base64.getEncoder().encodeToString(ivData), Base64.getEncoder().encodeToString(encryptedKey)));
        meta.setContentLength(contentLength);
    }

    private String buildEncryptionMetadataJSON(String iv64, String key64) {
        return String.format("{\"EncryptionMode\":\"FullBlob\",\"WrappedContentKey\":{\"KeyId\":\"symmKey1\",\"EncryptedKey\":\"%s\",\"Algorithm\":\"AES_CBC_256\"},\"EncryptionAgent\":{\"Protocol\":\"1.0\",\"EncryptionAlgorithm\":\"AES_CBC_256\"},\"ContentEncryptionIV\":\"%s\",\"KeyWrappingMetadata\":{\"EncryptionLibrary\":\"Java 5.3.0\"}}", key64, iv64);
    }

    private AbstractMap.SimpleEntry<String, String> parseEncryptionData(String jsonEncryptionData, String queryId) throws SnowflakeSQLException {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        JsonFactory factory = mapper.getFactory();
        try {
            JsonParser parser = factory.createParser(jsonEncryptionData);
            JsonNode encryptionDataNode = (JsonNode)mapper.readTree(parser);
            String iv = encryptionDataNode.get("ContentEncryptionIV").asText();
            String key = encryptionDataNode.get("WrappedContentKey").get("EncryptedKey").asText();
            return new AbstractMap.SimpleEntry<String, String>(key, iv);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLException(queryId, ex, "58000", ErrorCode.FILE_TRANSFER_ERROR.getMessageCode(), "Error parsing encryption data as json: " + ex.getMessage());
        }
    }

    @Override
    public void addDigestMetadata(StorageObjectMetadata meta, String digest) {
        if (!SnowflakeUtil.isBlank(digest)) {
            meta.addUserMetadata("sfc-digest", digest);
        }
    }

    @Override
    public String getDigestMetadata(StorageObjectMetadata meta) {
        return meta.getUserMetadata().get("sfc-digest");
    }

    private void setupGCSClient(StageInfo stage, RemoteStoreFileEncryptionMaterial encMat, SFSession session) throws IllegalArgumentException, SnowflakeSQLException {
        this.stageInfo = stage;
        this.encMat = encMat;
        this.session = session;
        logger.debug("Setting up the GCS client ", false);
        try {
            boolean overrideAwsAccessStrategy = Boolean.valueOf(System.getenv("SNOWFLAKE_GCS_FORCE_VIRTUAL_STYLE_DOMAINS"));
            this.gcsAccessStrategy = stage.getUseVirtualUrl() || overrideAwsAccessStrategy ? new GCSAccessStrategyAwsSdk(stage, session) : new GCSDefaultAccessStrategy(stage, session);
            if (encMat != null) {
                byte[] decodedKey = Base64.getDecoder().decode(encMat.getQueryStageMasterKey());
                this.encryptionKeySize = decodedKey.length * 8;
                if (this.encryptionKeySize != 128 && this.encryptionKeySize != 192 && this.encryptionKeySize != 256) {
                    throw new SnowflakeSQLException(QueryIdHelper.queryIdFromEncMatOr(encMat, null), "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "unsupported key size", this.encryptionKeySize);
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("invalid_gcs_credentials");
        }
    }

    protected static boolean areDisabledGcsDefaultCredentials(SFSession session) {
        return session != null && session.getDisableGcsDefaultCredentials() || SnowflakeUtil.convertSystemPropertyToBooleanValue(DISABLE_GCS_DEFAULT_CREDENTIALS_PROPERTY_NAME, true);
    }

    private static boolean isSuccessStatusCode(int code) {
        return code < 300 && code >= 200;
    }

    @Override
    public void addStreamingIngestMetadata(StorageObjectMetadata meta, String clientName, String clientKey) {
        meta.addUserMetadata(GCS_STREAMING_INGEST_CLIENT_NAME, clientName);
        meta.addUserMetadata(GCS_STREAMING_INGEST_CLIENT_KEY, clientKey);
    }

    @Override
    public String getStreamingIngestClientName(StorageObjectMetadata meta) {
        return meta.getUserMetadata().get(GCS_STREAMING_INGEST_CLIENT_NAME);
    }

    @Override
    public String getStreamingIngestClientKey(StorageObjectMetadata meta) {
        return meta.getUserMetadata().get(GCS_STREAMING_INGEST_CLIENT_KEY);
    }
}

