/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;

public final class DaemonThreadFactory
implements ThreadFactory {
    private final String namePrefix;
    private final AtomicInteger counter = new AtomicInteger();
    private final ThreadFactory delegate = Executors.defaultThreadFactory();
    private final boolean propagateContextForTesting;

    public DaemonThreadFactory(String namePrefix) {
        this(namePrefix, false);
    }

    public DaemonThreadFactory(String namePrefix, boolean propagateContextForTesting) {
        this.namePrefix = namePrefix;
        this.propagateContextForTesting = propagateContextForTesting;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread t2 = this.delegate.newThread(this.propagateContextForTesting ? Context.current().wrap(runnable) : runnable);
        try {
            t2.setDaemon(true);
            t2.setName(this.namePrefix + "-" + this.counter.incrementAndGet());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return t2;
    }
}

