/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.amazonaws.Protocol;
import com.google.common.base.Strings;
import java.io.Serializable;
import net.snowflake.client.core.OCSPMode;

public class HttpClientSettingsKey
implements Serializable {
    private OCSPMode ocspMode;
    private boolean useProxy;
    private String proxyHost = "";
    private int proxyPort = 0;
    private String nonProxyHosts = "";
    private String proxyUser = "";
    private String proxyPassword = "";
    private String proxyProtocol = "http";
    private String userAgentSuffix = "";
    private Boolean gzipDisabled = false;

    public HttpClientSettingsKey(OCSPMode mode, String host, int port, String nonProxyHosts, String user, String password, String scheme, String userAgentSuffix, Boolean gzipDisabled) {
        this.useProxy = true;
        this.ocspMode = mode != null ? mode : OCSPMode.FAIL_OPEN;
        this.proxyHost = !Strings.isNullOrEmpty((String)host) ? host.trim() : "";
        this.proxyPort = port;
        this.nonProxyHosts = !Strings.isNullOrEmpty((String)nonProxyHosts) ? nonProxyHosts.trim() : "";
        this.proxyUser = !Strings.isNullOrEmpty((String)user) ? user.trim() : "";
        this.proxyPassword = !Strings.isNullOrEmpty((String)password) ? password.trim() : "";
        this.proxyProtocol = !Strings.isNullOrEmpty((String)scheme) ? scheme.trim() : "http";
        this.gzipDisabled = gzipDisabled;
        this.userAgentSuffix = !Strings.isNullOrEmpty((String)userAgentSuffix) ? userAgentSuffix.trim() : "";
    }

    public HttpClientSettingsKey(OCSPMode mode) {
        this.useProxy = false;
        this.ocspMode = mode != null ? mode : OCSPMode.FAIL_OPEN;
    }

    HttpClientSettingsKey(OCSPMode mode, String userAgentSuffix, Boolean gzipDisabled) {
        this(mode);
        this.userAgentSuffix = !Strings.isNullOrEmpty((String)userAgentSuffix) ? userAgentSuffix.trim() : "";
        this.gzipDisabled = gzipDisabled;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HttpClientSettingsKey) {
            HttpClientSettingsKey comparisonKey = (HttpClientSettingsKey)obj;
            if (comparisonKey.ocspMode.getValue() == this.ocspMode.getValue() && comparisonKey.gzipDisabled.equals(this.gzipDisabled) && comparisonKey.userAgentSuffix.equalsIgnoreCase(this.userAgentSuffix)) {
                if (!comparisonKey.useProxy && !this.useProxy) {
                    return true;
                }
                if (comparisonKey.proxyHost.equalsIgnoreCase(this.proxyHost) && comparisonKey.proxyPort == this.proxyPort && comparisonKey.proxyUser.equalsIgnoreCase(this.proxyUser) && comparisonKey.proxyPassword.equalsIgnoreCase(this.proxyPassword) && comparisonKey.proxyProtocol.equalsIgnoreCase(this.proxyProtocol)) {
                    if (!this.nonProxyHosts.equalsIgnoreCase(comparisonKey.nonProxyHosts)) {
                        comparisonKey.nonProxyHosts = this.nonProxyHosts;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.ocspMode.getValue() + (this.proxyHost + this.proxyPort + this.proxyUser + this.proxyPassword + this.proxyProtocol).hashCode();
    }

    public OCSPMode getOcspMode() {
        return this.ocspMode;
    }

    public boolean usesProxy() {
        return this.useProxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public Protocol getProxyProtocol() {
        return this.proxyProtocol.equalsIgnoreCase("https") ? Protocol.HTTPS : Protocol.HTTP;
    }

    public Boolean getGzipDisabled() {
        return this.gzipDisabled;
    }
}

