/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

abstract class AbstractArrowVectorConverter
implements ArrowVectorConverter {
    protected String logicalTypeStr;
    private ValueVector valueVector;
    protected DataConversionContext context;
    protected int columnIndex;
    protected boolean treatNTZasUTC;
    protected boolean useSessionTimezone;
    protected TimeZone sessionTimeZone;
    public static final String FIELD_NAME_EPOCH = "epoch";
    public static final String FIELD_NAME_TIME_ZONE_INDEX = "timezone";
    public static final String FIELD_NAME_FRACTION = "fraction";

    AbstractArrowVectorConverter(String logicalTypeStr, ValueVector valueVector, int vectorIndex, DataConversionContext context) {
        this.logicalTypeStr = logicalTypeStr;
        this.valueVector = valueVector;
        this.columnIndex = vectorIndex + 1;
        this.context = context;
    }

    @Override
    public boolean toBoolean(int rowIndex) throws SFException {
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "boolean", "");
    }

    @Override
    public byte toByte(int rowIndex) throws SFException {
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byte", "");
    }

    @Override
    public short toShort(int rowIndex) throws SFException {
        if (this.isNull(rowIndex)) {
            return 0;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "short", "");
    }

    @Override
    public int toInt(int rowIndex) throws SFException {
        if (this.isNull(rowIndex)) {
            return 0;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "int");
    }

    @Override
    public long toLong(int rowIndex) throws SFException {
        if (this.isNull(rowIndex)) {
            return 0L;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "long", "");
    }

    @Override
    public double toDouble(int rowIndex) throws SFException {
        if (this.isNull(rowIndex)) {
            return 0.0;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "double", "");
    }

    @Override
    public float toFloat(int rowIndex) throws SFException {
        if (this.isNull(rowIndex)) {
            return 0.0f;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "float", "");
    }

    @Override
    public byte[] toBytes(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byteArray", "");
    }

    @Override
    public Date toDate(int index, TimeZone jvmTz, boolean useDateFormat) throws SFException {
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "date", "");
    }

    @Override
    public Time toTime(int index) throws SFException {
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "time", "");
    }

    @Override
    public Timestamp toTimestamp(int index, TimeZone tz) throws SFException {
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "timestamp", "");
    }

    @Override
    public BigDecimal toBigDecimal(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "big decimal", "");
    }

    @Override
    public void setTreatNTZAsUTC(boolean isUTC) {
        this.treatNTZasUTC = isUTC;
    }

    @Override
    public void setUseSessionTimezone(boolean useSessionTimezone) {
        this.useSessionTimezone = useSessionTimezone;
    }

    @Override
    public void setSessionTimeZone(TimeZone tz) {
        this.sessionTimeZone = tz;
    }

    @Override
    public boolean isNull(int index) {
        return this.valueVector.isNull(index);
    }

    @Override
    public abstract Object toObject(int var1) throws SFException;

    @Override
    public abstract String toString(int var1) throws SFException;

    public static class TimestampOperationNotAvailableException
    extends RuntimeException {
        private BigDecimal secsSinceEpoch;

        TimestampOperationNotAvailableException(long secsSinceEpoch, int fraction) {
            super("seconds=" + secsSinceEpoch + " nanos=" + fraction);
            this.secsSinceEpoch = new BigDecimal(secsSinceEpoch).add(new BigDecimal(fraction).scaleByPowerOfTen(-9));
        }

        public BigDecimal getSecsSinceEpoch() {
            return this.secsSinceEpoch;
        }
    }
}

